/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.source.enumerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.jdbc.source.enumerator.JdbcSourceEnumeratorState;
import org.apache.flink.connector.jdbc.source.enumerator.JdbcSqlSplitEnumeratorBase;
import org.apache.flink.connector.jdbc.source.split.JdbcSourceSplit;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcSourceEnumerator
implements SplitEnumerator<JdbcSourceSplit, JdbcSourceEnumeratorState> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcSourceEnumerator.class);
    private final SplitEnumeratorContext<JdbcSourceSplit> context;
    private final Boundedness boundedness;
    private final List<JdbcSourceSplit> unassigned;
    private final JdbcSqlSplitEnumeratorBase<JdbcSourceSplit> sqlSplitEnumerator;

    public JdbcSourceEnumerator(SplitEnumeratorContext<JdbcSourceSplit> context, JdbcSqlSplitEnumeratorBase<JdbcSourceSplit> sqlSplitEnumerator, List<JdbcSourceSplit> unassigned) {
        this.context = (SplitEnumeratorContext)Preconditions.checkNotNull(context);
        this.sqlSplitEnumerator = (JdbcSqlSplitEnumeratorBase)Preconditions.checkNotNull(sqlSplitEnumerator);
        this.boundedness = Boundedness.BOUNDED;
        this.unassigned = (List)Preconditions.checkNotNull(unassigned);
    }

    public void start() {
        this.sqlSplitEnumerator.open();
        try {
            this.unassigned.addAll(this.sqlSplitEnumerator.enumerateSplits());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        this.sqlSplitEnumerator.close();
    }

    public void addReader(int subtaskId) {
    }

    public void handleSplitRequest(int subtask, @Nullable String hostname) {
        if (this.boundedness == Boundedness.BOUNDED) {
            this.assignSplitsForBounded(subtask, hostname);
        }
    }

    public void handleSourceEvent(int subtaskId, SourceEvent sourceEvent) {
        LOG.error("Received unrecognized event: {}", (Object)sourceEvent);
    }

    public void addSplitsBack(List<JdbcSourceSplit> splits, int subtaskId) {
        LOG.debug("File Source Enumerator adds splits back: {}", splits);
        this.unassigned.addAll(splits);
    }

    public JdbcSourceEnumeratorState snapshotState(long checkpointId) throws Exception {
        LOG.debug("Source Checkpoint is {}", (Object)checkpointId);
        return new JdbcSourceEnumeratorState(Collections.emptyList(), Collections.emptyList(), new ArrayList<JdbcSourceSplit>(this.unassigned), this.sqlSplitEnumerator.optionalSqlSplitEnumeratorState);
    }

    private Optional<JdbcSourceSplit> getNextSplit() {
        if (this.unassigned == null || this.unassigned.isEmpty()) {
            return Optional.empty();
        }
        Iterator<JdbcSourceSplit> iterator = this.unassigned.iterator();
        JdbcSourceSplit next = null;
        if (iterator.hasNext()) {
            next = iterator.next();
            iterator.remove();
        }
        return Optional.ofNullable(next);
    }

    private void assignSplitsForBounded(int subtask, @Nullable String hostname) {
        Optional<JdbcSourceSplit> nextSplit;
        if (!this.context.registeredReaders().containsKey(subtask)) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            String hostInfo = hostname == null ? "(no host locality info)" : "(on host '" + hostname + "')";
            LOG.info("Subtask {} {} is requesting a Jdbc source split", (Object)subtask, (Object)hostInfo);
        }
        if ((nextSplit = this.getNextSplit()).isPresent()) {
            JdbcSourceSplit split = nextSplit.get();
            this.context.assignSplit((SourceSplit)split, subtask);
            LOG.info("Assigned split to subtask {} : {}", (Object)subtask, (Object)split);
        } else {
            this.context.signalNoMoreSplits(subtask);
            LOG.info("No more splits available for subtask {}", (Object)subtask);
        }
    }
}

