/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class JdbcConnectionOptions
implements Serializable {
    public static final String USER_KEY = "user";
    public static final String PASSWORD_KEY = "password";
    private static final long serialVersionUID = 1L;
    protected final String url;
    @Nullable
    protected final String driverName;
    protected final int connectionCheckTimeoutSeconds;
    @Nonnull
    protected final Properties properties;

    protected JdbcConnectionOptions(String url, @Nullable String driverName, int connectionCheckTimeoutSeconds, @Nonnull Properties properties) {
        Preconditions.checkArgument((connectionCheckTimeoutSeconds > 0 ? 1 : 0) != 0, (Object)"Connection check timeout seconds shouldn't be smaller than 1");
        this.url = (String)Preconditions.checkNotNull((Object)url, (String)"jdbc url is empty");
        this.driverName = driverName;
        this.connectionCheckTimeoutSeconds = connectionCheckTimeoutSeconds;
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"Connection properties must be non-null");
    }

    public String getDbURL() {
        return this.url;
    }

    @Nullable
    public String getDriverName() {
        return this.driverName;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.properties.getProperty(USER_KEY));
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.properties.getProperty(PASSWORD_KEY));
    }

    public int getConnectionCheckTimeoutSeconds() {
        return this.connectionCheckTimeoutSeconds;
    }

    @Nonnull
    public Properties getProperties() {
        return this.properties;
    }

    @Nonnull
    public static Properties getBriefAuthProperties(String user, String password) {
        Properties result = new Properties();
        if (Objects.nonNull(user)) {
            result.put(USER_KEY, user);
        }
        if (Objects.nonNull(password)) {
            result.put(PASSWORD_KEY, password);
        }
        return result;
    }

    public static class JdbcConnectionOptionsBuilder {
        private String url;
        private String driverName;
        private int connectionCheckTimeoutSeconds = 60;
        private final Properties properties = new Properties();

        public JdbcConnectionOptionsBuilder withUrl(String url) {
            this.url = url;
            return this;
        }

        public JdbcConnectionOptionsBuilder withDriverName(String driverName) {
            this.driverName = driverName;
            return this;
        }

        public JdbcConnectionOptionsBuilder withProperty(String propKey, String propVal) {
            Preconditions.checkNotNull((Object)propKey, (String)"Connection property key mustn't be null");
            Preconditions.checkNotNull((Object)propVal, (String)"Connection property value mustn't be null");
            this.properties.put(propKey, propVal);
            return this;
        }

        public JdbcConnectionOptionsBuilder withUsername(String username) {
            if (Objects.nonNull(username)) {
                this.properties.put(JdbcConnectionOptions.USER_KEY, username);
            }
            return this;
        }

        public JdbcConnectionOptionsBuilder withPassword(String password) {
            if (Objects.nonNull(password)) {
                this.properties.put(JdbcConnectionOptions.PASSWORD_KEY, password);
            }
            return this;
        }

        public JdbcConnectionOptionsBuilder withConnectionCheckTimeoutSeconds(int connectionCheckTimeoutSeconds) {
            this.connectionCheckTimeoutSeconds = connectionCheckTimeoutSeconds;
            return this;
        }

        public JdbcConnectionOptions build() {
            return new JdbcConnectionOptions(this.url, this.driverName, this.connectionCheckTimeoutSeconds, this.properties);
        }
    }
}

