/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc;

import java.io.Serializable;
import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class JdbcExactlyOnceOptions
implements Serializable {
    private static final boolean DEFAULT_RECOVERED_AND_ROLLBACK = true;
    private static final int DEFAULT_MAX_COMMIT_ATTEMPTS = 3;
    private static final boolean DEFAULT_ALLOW_OUT_OF_ORDER_COMMITS = false;
    public static final boolean DEFAULT_TRANSACTION_PER_CONNECTION = false;
    private final boolean discoverAndRollbackOnRecovery;
    private final int maxCommitAttempts;
    private final boolean allowOutOfOrderCommits;
    private final Integer timeoutSec;
    private final boolean transactionPerConnection;

    private JdbcExactlyOnceOptions(boolean discoverAndRollbackOnRecovery, int maxCommitAttempts, boolean allowOutOfOrderCommits, Optional<Integer> timeoutSec, boolean transactionPerConnection) {
        this.discoverAndRollbackOnRecovery = discoverAndRollbackOnRecovery;
        this.maxCommitAttempts = maxCommitAttempts;
        this.allowOutOfOrderCommits = allowOutOfOrderCommits;
        this.timeoutSec = timeoutSec.orElse(null);
        this.transactionPerConnection = transactionPerConnection;
        Preconditions.checkArgument((this.maxCommitAttempts > 0 ? 1 : 0) != 0, (Object)"maxCommitAttempts should be > 0");
    }

    public static JdbcExactlyOnceOptions defaults() {
        return JdbcExactlyOnceOptions.builder().build();
    }

    public boolean isDiscoverAndRollbackOnRecovery() {
        return this.discoverAndRollbackOnRecovery;
    }

    public boolean isAllowOutOfOrderCommits() {
        return this.allowOutOfOrderCommits;
    }

    public int getMaxCommitAttempts() {
        return this.maxCommitAttempts;
    }

    public Integer getTimeoutSec() {
        return this.timeoutSec;
    }

    public boolean isTransactionPerConnection() {
        return this.transactionPerConnection;
    }

    public static JDBCExactlyOnceOptionsBuilder builder() {
        return new JDBCExactlyOnceOptionsBuilder();
    }

    @PublicEvolving
    public static class JDBCExactlyOnceOptionsBuilder {
        private boolean recoveredAndRollback = true;
        private int maxCommitAttempts = 3;
        private boolean allowOutOfOrderCommits = false;
        private Optional<Integer> timeoutSec = Optional.empty();
        private boolean transactionPerConnection = false;

        public JDBCExactlyOnceOptionsBuilder withRecoveredAndRollback(boolean recoveredAndRollback) {
            this.recoveredAndRollback = recoveredAndRollback;
            return this;
        }

        public JDBCExactlyOnceOptionsBuilder withMaxCommitAttempts(int maxCommitAttempts) {
            this.maxCommitAttempts = maxCommitAttempts;
            return this;
        }

        public JDBCExactlyOnceOptionsBuilder withAllowOutOfOrderCommits(boolean allowOutOfOrderCommits) {
            this.allowOutOfOrderCommits = allowOutOfOrderCommits;
            return this;
        }

        public JDBCExactlyOnceOptionsBuilder withTimeoutSec(Optional<Integer> timeoutSec) {
            this.timeoutSec = timeoutSec;
            return this;
        }

        public JDBCExactlyOnceOptionsBuilder withTransactionPerConnection(boolean transactionPerConnection) {
            this.transactionPerConnection = transactionPerConnection;
            return this;
        }

        public JdbcExactlyOnceOptions build() {
            return new JdbcExactlyOnceOptions(this.recoveredAndRollback, this.maxCommitAttempts, this.allowOutOfOrderCommits, this.timeoutSec, this.transactionPerConnection);
        }
    }
}

