/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.core.database;

import java.util.LinkedList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.database.JdbcFactory;
import org.apache.flink.connector.jdbc.core.database.catalog.JdbcCatalog;
import org.apache.flink.connector.jdbc.core.database.dialect.JdbcDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class JdbcFactoryLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcFactoryLoader.class);

    private JdbcFactoryLoader() {
    }

    public static JdbcDialect loadDialect(String url, ClassLoader classLoader) {
        return JdbcFactoryLoader.loadDialect(url, classLoader, null);
    }

    public static JdbcDialect loadDialect(String url, ClassLoader classLoader, String compatibleMode) {
        return JdbcFactoryLoader.load(url, classLoader).createDialect(compatibleMode);
    }

    public static JdbcCatalog loadCatalog(ClassLoader classLoader, String catalogName, String defaultDatabase, String username, String pwd, String baseUrl) {
        return JdbcFactoryLoader.loadCatalog(classLoader, catalogName, defaultDatabase, username, pwd, baseUrl, null);
    }

    public static JdbcCatalog loadCatalog(ClassLoader classLoader, String catalogName, String defaultDatabase, String username, String pwd, String baseUrl, String compatibleMode) {
        return JdbcFactoryLoader.load(baseUrl, classLoader).createCatalog(classLoader, catalogName, defaultDatabase, username, pwd, baseUrl, compatibleMode);
    }

    private static JdbcFactory load(String url, ClassLoader classLoader) {
        List<JdbcFactory> foundFactories = JdbcFactoryLoader.discoverFactories(classLoader);
        if (foundFactories.isEmpty()) {
            throw new IllegalStateException(String.format("Could not find any jdbc factories that implement '%s' in the classpath.", JdbcFactory.class.getName()));
        }
        List matchingFactories = foundFactories.stream().filter(f -> f.acceptsURL(url)).collect(Collectors.toList());
        if (matchingFactories.isEmpty()) {
            throw new IllegalStateException(String.format("Could not find any jdbc factory that can handle url '%s' that implements '%s' in the classpath.\n\nAvailable factories are:\n\n%s", url, JdbcFactory.class.getName(), foundFactories.stream().map(f -> f.getClass().getName()).distinct().sorted().collect(Collectors.joining("\n"))));
        }
        if (matchingFactories.size() > 1) {
            throw new IllegalStateException(String.format("Multiple jdbc factories can handle url '%s' that implement '%s' found in the classpath.\n\nAmbiguous factory classes are:\n\n%s", url, JdbcFactory.class.getName(), matchingFactories.stream().map(f -> f.getClass().getName()).sorted().collect(Collectors.joining("\n"))));
        }
        return (JdbcFactory)matchingFactories.get(0);
    }

    private static List<JdbcFactory> discoverFactories(ClassLoader classLoader) {
        try {
            LinkedList<JdbcFactory> result = new LinkedList<JdbcFactory>();
            ServiceLoader.load(JdbcFactory.class, classLoader).iterator().forEachRemaining(result::add);
            return result;
        }
        catch (ServiceConfigurationError e) {
            LOG.error("Could not load service provider for jdbc factory.", (Throwable)e);
            throw new RuntimeException("Could not load service provider for jdbc factory.", e);
        }
    }
}

