/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.core.datastream.sink;

import javax.sql.XADataSource;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.JdbcExactlyOnceOptions;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.JdbcStatementBuilder;
import org.apache.flink.connector.jdbc.core.datastream.sink.JdbcSink;
import org.apache.flink.connector.jdbc.datasource.connections.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.datasource.connections.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.datasource.connections.xa.PoolingXaConnectionProvider;
import org.apache.flink.connector.jdbc.datasource.connections.xa.SimpleXaConnectionProvider;
import org.apache.flink.connector.jdbc.datasource.connections.xa.XaConnectionProvider;
import org.apache.flink.connector.jdbc.datasource.statements.JdbcQueryStatement;
import org.apache.flink.connector.jdbc.datasource.statements.SimpleJdbcQueryStatement;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SerializableSupplier;

@PublicEvolving
public class JdbcSinkBuilder<IN> {
    private JdbcExecutionOptions executionOptions = JdbcExecutionOptions.defaults();
    private JdbcQueryStatement<IN> queryStatement;

    public JdbcSinkBuilder<IN> withExecutionOptions(JdbcExecutionOptions executionOptions) {
        this.executionOptions = (JdbcExecutionOptions)Preconditions.checkNotNull((Object)executionOptions, (String)"executionOptions cannot be null");
        return this;
    }

    public JdbcSinkBuilder<IN> withQueryStatement(JdbcQueryStatement<IN> queryStatement) {
        this.queryStatement = queryStatement;
        return this;
    }

    public JdbcSinkBuilder<IN> withQueryStatement(String query, JdbcStatementBuilder<IN> statement) {
        this.queryStatement = new SimpleJdbcQueryStatement<IN>(query, statement);
        return this;
    }

    public JdbcSink<IN> buildAtLeastOnce(JdbcConnectionOptions connectionOptions) {
        Preconditions.checkNotNull((Object)connectionOptions, (String)"connectionOptions cannot be null");
        return this.buildAtLeastOnce(new SimpleJdbcConnectionProvider(connectionOptions));
    }

    public JdbcSink<IN> buildAtLeastOnce(JdbcConnectionProvider connectionProvider) {
        Preconditions.checkNotNull((Object)connectionProvider, (String)"connectionProvider cannot be null");
        return this.build(DeliveryGuarantee.AT_LEAST_ONCE, JdbcExactlyOnceOptions.defaults(), (JdbcConnectionProvider)Preconditions.checkNotNull((Object)connectionProvider, (String)"connectionProvider cannot be null"));
    }

    public JdbcSink<IN> buildExactlyOnce(JdbcExactlyOnceOptions exactlyOnceOptions, SerializableSupplier<XADataSource> dataSourceSupplier) {
        Preconditions.checkNotNull((Object)exactlyOnceOptions, (String)"exactlyOnceOptions cannot be null");
        Preconditions.checkNotNull(dataSourceSupplier, (String)"dataSourceSupplier cannot be null");
        XaConnectionProvider connectionProvider = exactlyOnceOptions.isTransactionPerConnection() ? PoolingXaConnectionProvider.from(dataSourceSupplier, exactlyOnceOptions.getTimeoutSec()) : SimpleXaConnectionProvider.from(dataSourceSupplier, exactlyOnceOptions.getTimeoutSec());
        return this.buildExactlyOnce(exactlyOnceOptions, connectionProvider);
    }

    public JdbcSink<IN> buildExactlyOnce(JdbcExactlyOnceOptions exactlyOnceOptions, XaConnectionProvider connectionProvider) {
        return this.build(DeliveryGuarantee.EXACTLY_ONCE, (JdbcExactlyOnceOptions)Preconditions.checkNotNull((Object)exactlyOnceOptions, (String)"exactlyOnceOptions cannot be null"), (JdbcConnectionProvider)Preconditions.checkNotNull((Object)connectionProvider, (String)"connectionProvider cannot be null"));
    }

    private JdbcSink<IN> build(DeliveryGuarantee deliveryGuarantee, JdbcExactlyOnceOptions exactlyOnceOptions, JdbcConnectionProvider connectionProvider) {
        return new JdbcSink((DeliveryGuarantee)Preconditions.checkNotNull((Object)deliveryGuarantee, (String)"deliveryGuarantee cannot be null"), (JdbcConnectionProvider)Preconditions.checkNotNull((Object)connectionProvider, (String)"connectionProvider cannot be null"), (JdbcExecutionOptions)Preconditions.checkNotNull((Object)this.executionOptions, (String)"executionOptions cannot be null"), (JdbcExactlyOnceOptions)Preconditions.checkNotNull((Object)exactlyOnceOptions, (String)"exactlyOnceOptions cannot be null"), (JdbcQueryStatement)Preconditions.checkNotNull(this.queryStatement, (String)"queryStatement cannot be null"));
    }
}

