/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.core.datastream.sink.writer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.datasource.transactions.xa.domain.TransactionId;

@ThreadSafe
@Internal
public class JdbcWriterState
implements Serializable {
    private final Collection<TransactionId> prepared;
    private final Collection<TransactionId> hanging;

    public static JdbcWriterState empty() {
        return new JdbcWriterState(Collections.emptyList(), Collections.emptyList());
    }

    public static JdbcWriterState of(Collection<TransactionId> prepared, Collection<TransactionId> hanging) {
        return new JdbcWriterState(Collections.unmodifiableList(new ArrayList<TransactionId>(prepared)), Collections.unmodifiableList(new ArrayList<TransactionId>(hanging)));
    }

    protected JdbcWriterState(Collection<TransactionId> prepared, Collection<TransactionId> hanging) {
        this.prepared = prepared;
        this.hanging = hanging;
    }

    public Collection<TransactionId> getPrepared() {
        return this.prepared;
    }

    public Collection<TransactionId> getHanging() {
        return this.hanging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcWriterState that = (JdbcWriterState)o;
        return new EqualsBuilder().append(this.prepared, that.prepared).append(this.hanging, that.hanging).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.prepared).append(this.hanging).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("prepared", this.prepared).append("hanging", this.hanging).toString();
    }
}

