/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.core.datastream.sink.writer;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.datastream.sink.writer.JdbcWriterState;
import org.apache.flink.connector.jdbc.datasource.transactions.xa.domain.TransactionId;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class JdbcWriterStateSerializer
implements SimpleVersionedSerializer<JdbcWriterState> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcWriterStateSerializer.class);

    public int getVersion() {
        return 2;
    }

    public byte[] serialize(JdbcWriterState state) throws IOException {
        byte[] tIdBytes;
        DataOutputSerializer out = new DataOutputSerializer(1);
        out.writeInt(state.getHanging().size());
        for (TransactionId tid : state.getHanging()) {
            tIdBytes = tid.serialize();
            out.writeByte(tIdBytes.length);
            out.write(tIdBytes, 0, tIdBytes.length);
        }
        out.writeInt(state.getPrepared().size());
        for (TransactionId tid : state.getPrepared()) {
            tIdBytes = tid.serialize();
            out.writeByte(tIdBytes.length);
            out.write(tIdBytes, 0, tIdBytes.length);
        }
        return out.getSharedBuffer();
    }

    public JdbcWriterState deserialize(int version, byte[] serialized) throws IOException {
        if (version == this.getVersion()) {
            DataInputDeserializer in = new DataInputDeserializer(serialized);
            return this.deserializeV2(in);
        }
        LOG.error("Unknown version of state: {}", (Object)version);
        return JdbcWriterState.empty();
    }

    private JdbcWriterState deserializeV2(DataInputDeserializer in) throws IOException {
        int hangingSize = in.readInt();
        ArrayList<TransactionId> hanging = new ArrayList<TransactionId>(hangingSize);
        for (int i = 0; i < hangingSize; ++i) {
            byte len = in.readByte();
            byte[] bytes = new byte[len];
            in.read(bytes, 0, (int)len);
            hanging.add(TransactionId.deserialize(bytes));
        }
        int preparedSize = in.readInt();
        ArrayList<TransactionId> prepared = new ArrayList<TransactionId>(preparedSize);
        for (int i = 0; i < preparedSize; ++i) {
            byte len = in.readByte();
            byte[] bytes = new byte[len];
            in.read(bytes, 0, (int)len);
            prepared.add(TransactionId.deserialize(bytes));
        }
        return JdbcWriterState.of(prepared, hanging);
    }
}

