/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.core.datastream.source;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.jdbc.core.datastream.source.JdbcSourceBuilder;
import org.apache.flink.connector.jdbc.core.datastream.source.config.ContinuousUnBoundingSettings;
import org.apache.flink.connector.jdbc.core.datastream.source.enumerator.JdbcSourceEnumStateSerializer;
import org.apache.flink.connector.jdbc.core.datastream.source.enumerator.JdbcSourceEnumerator;
import org.apache.flink.connector.jdbc.core.datastream.source.enumerator.JdbcSourceEnumeratorState;
import org.apache.flink.connector.jdbc.core.datastream.source.enumerator.JdbcSqlSplitEnumeratorBase;
import org.apache.flink.connector.jdbc.core.datastream.source.reader.JdbcSourceReader;
import org.apache.flink.connector.jdbc.core.datastream.source.reader.JdbcSourceSplitReader;
import org.apache.flink.connector.jdbc.core.datastream.source.reader.extractor.ResultExtractor;
import org.apache.flink.connector.jdbc.core.datastream.source.split.JdbcSourceSplit;
import org.apache.flink.connector.jdbc.core.datastream.source.split.JdbcSourceSplitSerializer;
import org.apache.flink.connector.jdbc.datasource.connections.JdbcConnectionProvider;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class JdbcSource<OUT>
implements Source<OUT, JdbcSourceSplit, JdbcSourceEnumeratorState>,
ResultTypeQueryable<OUT> {
    private final Boundedness boundedness;
    private final TypeInformation<OUT> typeInformation;
    @Nullable
    private final ContinuousUnBoundingSettings continuousUnBoundingSettings;
    private final Configuration configuration;
    private final JdbcSqlSplitEnumeratorBase.Provider<JdbcSourceSplit> sqlSplitEnumeratorProvider;
    protected JdbcConnectionProvider connectionProvider;
    private final ResultExtractor<OUT> resultExtractor;
    private final DeliveryGuarantee deliveryGuarantee;

    JdbcSource(Configuration configuration, JdbcConnectionProvider connectionProvider, JdbcSqlSplitEnumeratorBase.Provider<JdbcSourceSplit> sqlSplitEnumeratorProvider, ResultExtractor<OUT> resultExtractor, TypeInformation<OUT> typeInformation, @Nullable DeliveryGuarantee deliveryGuarantee, @Nullable ContinuousUnBoundingSettings continuousUnBoundingSettings) {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.connectionProvider = (JdbcConnectionProvider)Preconditions.checkNotNull((Object)connectionProvider);
        this.sqlSplitEnumeratorProvider = (JdbcSqlSplitEnumeratorBase.Provider)Preconditions.checkNotNull(sqlSplitEnumeratorProvider);
        this.resultExtractor = (ResultExtractor)Preconditions.checkNotNull(resultExtractor);
        this.deliveryGuarantee = Objects.isNull(deliveryGuarantee) ? DeliveryGuarantee.NONE : deliveryGuarantee;
        this.typeInformation = (TypeInformation)Preconditions.checkNotNull(typeInformation);
        this.continuousUnBoundingSettings = continuousUnBoundingSettings;
        this.boundedness = Objects.isNull(continuousUnBoundingSettings) ? Boundedness.BOUNDED : Boundedness.CONTINUOUS_UNBOUNDED;
    }

    public Boundedness getBoundedness() {
        return this.boundedness;
    }

    public SourceReader<OUT, JdbcSourceSplit> createReader(SourceReaderContext readerContext) throws Exception {
        return new JdbcSourceReader(() -> new JdbcSourceSplitReader<OUT>(readerContext, this.configuration, this.typeInformation, this.connectionProvider, this.deliveryGuarantee, this.resultExtractor), this.configuration, readerContext);
    }

    public SplitEnumerator<JdbcSourceSplit, JdbcSourceEnumeratorState> createEnumerator(SplitEnumeratorContext<JdbcSourceSplit> enumContext) throws Exception {
        return new JdbcSourceEnumerator(enumContext, this.sqlSplitEnumeratorProvider.create(), this.continuousUnBoundingSettings, new ArrayList<JdbcSourceSplit>());
    }

    public SplitEnumerator<JdbcSourceSplit, JdbcSourceEnumeratorState> restoreEnumerator(SplitEnumeratorContext<JdbcSourceSplit> enumContext, JdbcSourceEnumeratorState checkpoint) throws Exception {
        Serializable optionalUserDefinedSplitEnumeratorState = checkpoint.getOptionalUserDefinedSplitEnumeratorState();
        return new JdbcSourceEnumerator(enumContext, this.sqlSplitEnumeratorProvider.restore(optionalUserDefinedSplitEnumeratorState), this.continuousUnBoundingSettings, checkpoint.getRemainingSplits());
    }

    public SimpleVersionedSerializer<JdbcSourceSplit> getSplitSerializer() {
        return new JdbcSourceSplitSerializer();
    }

    public SimpleVersionedSerializer<JdbcSourceEnumeratorState> getEnumeratorCheckpointSerializer() {
        return new JdbcSourceEnumStateSerializer((JdbcSourceSplitSerializer)this.getSplitSerializer());
    }

    public TypeInformation<OUT> getProducedType() {
        return this.typeInformation;
    }

    public static <OUT> JdbcSourceBuilder<OUT> builder() {
        return new JdbcSourceBuilder();
    }

    @VisibleForTesting
    public JdbcSqlSplitEnumeratorBase.Provider<JdbcSourceSplit> getSqlSplitEnumeratorProvider() {
        return this.sqlSplitEnumeratorProvider;
    }

    @VisibleForTesting
    public TypeInformation<OUT> getTypeInformation() {
        return this.typeInformation;
    }

    @VisibleForTesting
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @VisibleForTesting
    public ResultExtractor<OUT> getResultExtractor() {
        return this.resultExtractor;
    }

    @VisibleForTesting
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcSource that = (JdbcSource)o;
        return this.boundedness == that.boundedness && Objects.equals(this.typeInformation, that.typeInformation) && Objects.equals(this.configuration, that.configuration) && Objects.equals(this.sqlSplitEnumeratorProvider, that.sqlSplitEnumeratorProvider) && Objects.equals(this.connectionProvider, that.connectionProvider) && Objects.equals(this.resultExtractor, that.resultExtractor) && this.deliveryGuarantee == that.deliveryGuarantee && Objects.equals(this.continuousUnBoundingSettings, that.continuousUnBoundingSettings);
    }
}

