/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.core.datastream.source.enumerator;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.jdbc.core.datastream.source.split.JdbcSourceSplit;

@PublicEvolving
public abstract class JdbcSqlSplitEnumeratorBase<SplitT>
implements AutoCloseable,
Serializable {
    private final char[] currentId = "0000000000".toCharArray();
    @Nullable
    protected Serializable optionalSqlSplitEnumeratorState;

    public JdbcSqlSplitEnumeratorBase(@Nullable Serializable optionalSqlSplitEnumeratorState) {
        this.optionalSqlSplitEnumeratorState = optionalSqlSplitEnumeratorState;
    }

    protected final String getNextId() {
        JdbcSqlSplitEnumeratorBase.incrementCharArrayByOne(this.currentId, this.currentId.length - 1);
        return new String(this.currentId);
    }

    private static void incrementCharArrayByOne(char[] array, int pos) {
        int c = array[pos];
        if ((c = (char)(c + '\u0001')) > 57) {
            c = 48;
            JdbcSqlSplitEnumeratorBase.incrementCharArrayByOne(array, pos - 1);
        }
        array[pos] = c;
    }

    public abstract List<JdbcSourceSplit> enumerateSplits(@Nonnull Supplier<Boolean> var1) throws IOException;

    public void open() {
    }

    @Override
    public void close() {
    }

    @PublicEvolving
    public static interface Provider<SplitT>
    extends Serializable {
        public JdbcSqlSplitEnumeratorBase<SplitT> create();

        public JdbcSqlSplitEnumeratorBase<SplitT> restore(@Nullable Serializable var1);
    }
}

