/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.core.table.source;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.connector.jdbc.core.table.source.ParameterizedPredicate;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionDefaultVisitor;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.types.logical.LogicalType;

@Experimental
public class JdbcFilterPushdownPreparedStatementVisitor
extends ExpressionDefaultVisitor<Optional<ParameterizedPredicate>> {
    private final Function<String, String> quoteIdentifierFunction;

    public JdbcFilterPushdownPreparedStatementVisitor(Function<String, String> quoteIdentifierFunction) {
        this.quoteIdentifierFunction = quoteIdentifierFunction;
    }

    public Optional<ParameterizedPredicate> visit(CallExpression call) {
        if (BuiltInFunctionDefinitions.EQUALS.equals(call.getFunctionDefinition())) {
            return this.renderBinaryOperator("=", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.LESS_THAN.equals(call.getFunctionDefinition())) {
            return this.renderBinaryOperator("<", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL.equals(call.getFunctionDefinition())) {
            return this.renderBinaryOperator("<=", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.GREATER_THAN.equals(call.getFunctionDefinition())) {
            return this.renderBinaryOperator(">", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL.equals(call.getFunctionDefinition())) {
            return this.renderBinaryOperator(">=", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.NOT_EQUALS.equals(call.getFunctionDefinition())) {
            return this.renderBinaryOperator("<>", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.OR.equals(call.getFunctionDefinition())) {
            return this.renderBinaryOperator("OR", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.AND.equals(call.getFunctionDefinition())) {
            return this.renderBinaryOperator("AND", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.LIKE.equals(call.getFunctionDefinition())) {
            return this.renderBinaryOperator("LIKE", call.getResolvedChildren());
        }
        if (BuiltInFunctionDefinitions.IS_NULL.equals(call.getFunctionDefinition())) {
            return this.renderUnaryOperator("IS NULL", (ResolvedExpression)call.getResolvedChildren().get(0), true);
        }
        if (BuiltInFunctionDefinitions.IS_NOT_NULL.equals(call.getFunctionDefinition())) {
            return this.renderUnaryOperator("IS NOT NULL", (ResolvedExpression)call.getResolvedChildren().get(0), true);
        }
        return Optional.empty();
    }

    private Optional<ParameterizedPredicate> renderBinaryOperator(String operator, List<ResolvedExpression> allOperands) {
        Optional leftOperandString = (Optional)allOperands.get(0).accept((ExpressionVisitor)this);
        Optional rightOperandString = (Optional)allOperands.get(1).accept((ExpressionVisitor)this);
        return leftOperandString.flatMap(left -> rightOperandString.map(right -> left.combine(operator, (ParameterizedPredicate)right)));
    }

    private Optional<ParameterizedPredicate> renderUnaryOperator(String operator, ResolvedExpression operand, boolean operandOnLeft) {
        if (operand instanceof FieldReferenceExpression) {
            Object fieldPartialPredicate = this.visit((FieldReferenceExpression)operand);
            if (operandOnLeft) {
                return ((Optional)fieldPartialPredicate).map(fieldPred -> new ParameterizedPredicate(String.format("(%s %s)", fieldPred.getPredicate(), operator)));
            }
            return ((Optional)fieldPartialPredicate).map(fieldPred -> new ParameterizedPredicate(String.format("(%s %s)", operator, fieldPred.getPredicate())));
        }
        return Optional.empty();
    }

    public Optional<ParameterizedPredicate> visit(ValueLiteralExpression litExp) {
        LogicalType tpe = litExp.getOutputDataType().getLogicalType();
        Serializable[] params = new Serializable[1];
        ParameterizedPredicate predicate = new ParameterizedPredicate("?");
        switch (tpe.getTypeRoot()) {
            case CHAR: {
                params[0] = litExp.getValueAs(String.class).orElse(null);
                predicate.setParameters(params);
                return Optional.of(predicate);
            }
            case VARCHAR: {
                params[0] = litExp.getValueAs(String.class).orElse(null);
                predicate.setParameters(params);
                return Optional.of(predicate);
            }
            case BOOLEAN: {
                params[0] = litExp.getValueAs(Boolean.class).orElse(null);
                predicate.setParameters(params);
                return Optional.of(predicate);
            }
            case DECIMAL: {
                params[0] = litExp.getValueAs(BigDecimal.class).orElse(null);
                predicate.setParameters(params);
                return Optional.of(predicate);
            }
            case TINYINT: {
                params[0] = litExp.getValueAs(Byte.class).orElse(null);
                predicate.setParameters(params);
                return Optional.of(predicate);
            }
            case SMALLINT: {
                params[0] = litExp.getValueAs(Short.class).orElse(null);
                predicate.setParameters(params);
                return Optional.of(predicate);
            }
            case INTEGER: {
                params[0] = litExp.getValueAs(Integer.class).orElse(null);
                predicate.setParameters(params);
                return Optional.of(predicate);
            }
            case BIGINT: {
                params[0] = litExp.getValueAs(Long.class).orElse(null);
                predicate.setParameters(params);
                return Optional.of(predicate);
            }
            case FLOAT: {
                params[0] = litExp.getValueAs(Float.class).orElse(null);
                predicate.setParameters(params);
                return Optional.of(predicate);
            }
            case DOUBLE: {
                params[0] = litExp.getValueAs(Double.class).orElse(null);
                predicate.setParameters(params);
                return Optional.of(predicate);
            }
            case DATE: {
                params[0] = litExp.getValueAs(LocalDate.class).map(Date::valueOf).orElse(null);
                predicate.setParameters(params);
                return Optional.of(predicate);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                params[0] = litExp.getValueAs(Time.class).orElse(null);
                predicate.setParameters(params);
                return Optional.of(predicate);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                params[0] = litExp.getValueAs(LocalDateTime.class).map(Timestamp::valueOf).orElse(null);
                predicate.setParameters(params);
                return Optional.of(predicate);
            }
        }
        return Optional.empty();
    }

    public Optional<ParameterizedPredicate> visit(FieldReferenceExpression fieldReference) {
        String predicateStr = this.quoteIdentifierFunction.apply(fieldReference.toString());
        ParameterizedPredicate predicate = new ParameterizedPredicate(predicateStr);
        return Optional.of(predicate);
    }

    protected Optional<ParameterizedPredicate> defaultMethod(Expression expression) {
        return Optional.empty();
    }
}

