/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.cratedb.database.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.compress.utils.Lists;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.cratedb.database.catalog.CrateDBTablePath;
import org.apache.flink.connector.jdbc.cratedb.database.catalog.CrateDBTypeMapper;
import org.apache.flink.connector.jdbc.postgres.database.catalog.PostgresCatalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class CrateDBCatalog
extends PostgresCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(CrateDBCatalog.class);
    public static final String DEFAULT_DATABASE = "crate";
    private static final Set<String> builtinSchemas = new HashSet<String>(){
        {
            this.add("pg_catalog");
            this.add("information_schema");
            this.add("sys");
        }
    };

    @VisibleForTesting
    public CrateDBCatalog(ClassLoader userClassLoader, String catalogName, String defaultDatabase, String username, String pwd, String baseUrl) {
        this(userClassLoader, catalogName, defaultDatabase, baseUrl, JdbcConnectionOptions.getBriefAuthProperties(username, pwd));
    }

    public CrateDBCatalog(ClassLoader userClassLoader, String catalogName, String defaultDatabase, String baseUrl, Properties connecProperties) {
        super(userClassLoader, catalogName, defaultDatabase, baseUrl, new CrateDBTypeMapper(), connecProperties);
    }

    @Override
    public List<String> listDatabases() throws CatalogException {
        return Collections.singletonList(DEFAULT_DATABASE);
    }

    @Override
    protected Set<String> getBuiltinSchemas() {
        return builtinSchemas;
    }

    @Override
    protected List<String> getPureTables(Connection conn, List<String> schemas) throws SQLException {
        ArrayList tables = Lists.newArrayList();
        try (PreparedStatement ps = conn.prepareStatement("SELECT table_name FROM information_schema.tables WHERE table_schema = ? ORDER BY table_type, table_name");){
            for (String schema : schemas) {
                CrateDBCatalog.extractColumnValuesByStatement(ps, 1, null, schema).stream().map(pureTable -> schema + "." + pureTable).forEach(tables::add);
            }
            ArrayList arrayList = tables;
            return arrayList;
        }
    }

    @Override
    public boolean tableExists(ObjectPath tablePath) throws CatalogException {
        List<String> tables;
        try {
            tables = this.listTables(tablePath.getDatabaseName());
        }
        catch (DatabaseNotExistException e) {
            return false;
        }
        String searchPath = this.extractColumnValuesBySQL(this.getDatabaseUrl(DEFAULT_DATABASE), "show search_path", 1, null, new Object[0]).get(0);
        String[] schemas = searchPath.split("\\s*,\\s*");
        if (tables.contains(this.getSchemaTableName(tablePath))) {
            return true;
        }
        for (String schema : schemas) {
            if (!tables.contains(schema + "." + tablePath.getObjectName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getTableName(ObjectPath tablePath) {
        return CrateDBTablePath.fromFlinkTableName(tablePath.getObjectName()).getPgTableName();
    }

    @Override
    protected String getSchemaName(ObjectPath tablePath) {
        return CrateDBTablePath.fromFlinkTableName(tablePath.getObjectName()).getPgSchemaName();
    }

    @Override
    protected String getSchemaTableName(ObjectPath tablePath) {
        return CrateDBTablePath.fromFlinkTableName(tablePath.getObjectName()).getFullPath();
    }
}

