/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.cratedb.database.catalog;

import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.postgres.database.catalog.PostgresTypeMapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class CrateDBTypeMapper
extends PostgresTypeMapper {
    private static final Logger LOG = LoggerFactory.getLogger(CrateDBTypeMapper.class);
    private static final String PG_STRING = "string";
    private static final String PG_STRING_ARRAY = "_string";

    @Override
    protected DataType getMapping(String pgType, int precision, int scale) {
        switch (pgType) {
            case "serial": 
            case "bigserial": {
                return null;
            }
            case "string": {
                return DataTypes.STRING();
            }
            case "_string": {
                return DataTypes.ARRAY((DataType)DataTypes.STRING());
            }
        }
        return super.getMapping(pgType, precision, scale);
    }

    @Override
    protected String getDBType() {
        return "CrateDB";
    }
}

