/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.datasource.transactions.xa;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.datasource.transactions.xa.exceptions.TransientXaException;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class XaTransactionResult<T> {
    private final List<T> succeeded = new ArrayList<T>();
    private final List<T> failed = new ArrayList<T>();
    private final List<T> toRetry = new ArrayList<T>();
    private Optional<Exception> failure = Optional.empty();
    private Optional<Exception> transientFailure = Optional.empty();

    void failedTransiently(T x, TransientXaException e) {
        this.toRetry.add(x);
        this.transientFailure = this.getTransientFailure().isPresent() ? this.getTransientFailure() : Optional.of(e);
    }

    void failed(T x, Exception e) {
        this.failed.add(x);
        this.failure = this.failure.isPresent() ? this.failure : Optional.of(e);
    }

    void succeeded(T x) {
        this.succeeded.add(x);
    }

    private FlinkRuntimeException wrapFailure(Exception error, String formatWithCounts, int errCount) {
        return new FlinkRuntimeException(String.format(formatWithCounts, errCount, this.total()), (Throwable)error);
    }

    private int total() {
        return this.succeeded.size() + this.failed.size() + this.toRetry.size();
    }

    public List<T> getForRetry() {
        return this.toRetry;
    }

    Optional<Exception> getTransientFailure() {
        return this.transientFailure;
    }

    boolean hasNoFailures() {
        return !this.failure.isPresent() && !this.transientFailure.isPresent();
    }

    void throwIfAnyFailed(String action) {
        this.failure.map(f -> this.wrapFailure((Exception)f, "failed to " + action + " %d transactions out of %d", this.toRetry.size() + this.failed.size())).ifPresent(f -> {
            throw f;
        });
    }
}

