/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.datasource.transactions.xa.domain;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@Internal
public class TransactionId
implements Xid,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int FORMAT_ID = 202;
    private final byte[] jobId;
    private final int subtaskId;
    private final int numberOfSubtasks;
    private final long checkpointId;
    private final int attempts;
    private final boolean restored;

    private TransactionId(byte[] jobId, int subtaskId, int numberOfSubtasks, long checkpointId, int attempts, boolean restored) {
        this.jobId = jobId;
        this.subtaskId = subtaskId;
        this.numberOfSubtasks = numberOfSubtasks;
        this.checkpointId = checkpointId;
        this.attempts = attempts;
        this.restored = restored;
    }

    public static TransactionId empty() {
        return TransactionId.create(new byte[16], 0, 0);
    }

    public static TransactionId create(byte[] jobId, int subtaskId, int numberOfSubtasks) {
        return new TransactionId(jobId, subtaskId, numberOfSubtasks, -1L, 0, false);
    }

    public static TransactionId restore(byte[] jobId, int subtaskId, int numberOfSubtasks, long checkpointId, int attempts) {
        return new TransactionId(jobId, subtaskId, numberOfSubtasks, checkpointId, attempts, true);
    }

    public static TransactionId createFromXid(int formatId, byte[] globalTransactionId, byte[] branchQualifier) throws IOException {
        return TransactionId.fromXid(formatId, globalTransactionId, branchQualifier, false);
    }

    public static TransactionId restoreFromXid(int formatId, byte[] globalTransactionId, byte[] branchQualifier) throws IOException {
        return TransactionId.fromXid(formatId, globalTransactionId, branchQualifier, true);
    }

    public static TransactionId fromXid(int formatId, byte[] globalTransactionId, byte[] branchQualifier, boolean restored) throws IOException {
        if (202 != formatId) {
            throw new IOException(String.format("Xid formatId (%s) is not valid", formatId));
        }
        DataInputDeserializer gid = new DataInputDeserializer(globalTransactionId);
        byte[] jobIdBytes = TransactionId.readJobId(gid);
        int subtaskId = gid.readInt();
        DataInputDeserializer branch = new DataInputDeserializer(branchQualifier);
        int numberOfSubtasks = branch.readInt();
        long checkpoint = branch.readLong();
        return new TransactionId(jobIdBytes, subtaskId, numberOfSubtasks, checkpoint, 0, restored);
    }

    public static TransactionId deserialize(byte[] bytes) {
        try {
            DataInputDeserializer in = new DataInputDeserializer(bytes);
            byte[] jobIdBytes = TransactionId.readJobId(in);
            int subtaskId = in.readInt();
            int numberOfSubtasks = in.readInt();
            long checkpoint = in.readLong();
            int attempts = in.readInt();
            return TransactionId.restore(jobIdBytes, subtaskId, numberOfSubtasks, checkpoint, attempts);
        }
        catch (IOException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    private static byte[] readJobId(DataInputDeserializer in) throws IOException {
        byte[] jobIdBytes = new byte[16];
        in.read(jobIdBytes);
        return jobIdBytes;
    }

    public TransactionId copy() {
        return new TransactionId(this.jobId, this.subtaskId, this.numberOfSubtasks, this.checkpointId, this.attempts, this.restored);
    }

    public TransactionId withBranch(long checkpointId) {
        return new TransactionId(this.jobId, this.subtaskId, this.numberOfSubtasks, checkpointId, this.attempts, this.restored);
    }

    public TransactionId withAttemptsIncremented() {
        return new TransactionId(this.jobId, this.subtaskId, this.numberOfSubtasks, this.checkpointId, this.attempts + 1, this.restored);
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public boolean getRestored() {
        return this.restored;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public String getXidValue() {
        return String.format("%s:%s:%s", this.getFormatId(), StringUtils.byteToHexString((byte[])this.getGlobalTransactionId()), StringUtils.byteToHexString((byte[])this.getBranchQualifier()));
    }

    @Override
    public int getFormatId() {
        return 202;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        try {
            DataOutputSerializer out = new DataOutputSerializer(1);
            out.write(this.jobId, 0, 16);
            out.writeInt(this.subtaskId);
            return out.getSharedBuffer();
        }
        catch (IOException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    @Override
    public byte[] getBranchQualifier() {
        Preconditions.checkArgument((this.checkpointId >= 0L ? 1 : 0) != 0, (Object)"No branch was initialized");
        try {
            DataOutputSerializer out = new DataOutputSerializer(1);
            out.writeInt(this.numberOfSubtasks);
            out.writeLong(this.checkpointId);
            return out.getSharedBuffer();
        }
        catch (IOException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public byte[] serialize() {
        try {
            DataOutputSerializer out = new DataOutputSerializer(1);
            out.write(this.jobId, 0, 16);
            out.writeInt(this.subtaskId);
            out.writeInt(this.numberOfSubtasks);
            out.writeLong(this.checkpointId);
            out.writeInt(this.attempts);
            return out.getSharedBuffer();
        }
        catch (IOException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public boolean belongsTo(Xid xid) {
        if (!(xid instanceof TransactionId)) {
            return false;
        }
        TransactionId tXid = (TransactionId)xid;
        if (202 != tXid.getFormatId() || !Arrays.equals(this.jobId, tXid.jobId)) {
            return false;
        }
        if (this.subtaskId == tXid.subtaskId && this.numberOfSubtasks == tXid.numberOfSubtasks) {
            return true;
        }
        return this.numberOfSubtasks < tXid.subtaskId;
    }

    public boolean equals(Object other) {
        return this.equals(other, false);
    }

    public boolean equals(Object other, boolean withInternal) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransactionId that = (TransactionId)other;
        EqualsBuilder builder = new EqualsBuilder().append(this.jobId, that.jobId).append(this.subtaskId, that.subtaskId).append(this.numberOfSubtasks, that.numberOfSubtasks).append(this.checkpointId, that.checkpointId);
        if (withInternal) {
            builder.append(this.attempts, that.attempts).append(this.restored, that.restored);
        }
        return builder.isEquals();
    }

    public int hashCode() {
        return this.hashCode(false);
    }

    public int hashCode(boolean withInternal) {
        HashCodeBuilder builder = new HashCodeBuilder(17, 37).append(this.jobId).append(this.subtaskId).append(this.numberOfSubtasks).append(this.checkpointId);
        if (withInternal) {
            builder.append(this.attempts).append(this.restored);
        }
        return builder.toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.JSON_STYLE).append("jobId", this.jobId).append("subtaskId", this.subtaskId).append("numberOfSubtasks", this.numberOfSubtasks).append("checkpointId", this.checkpointId).append("attempts", this.attempts).append("restored", this.restored).toString();
    }
}

