/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.executor;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.JdbcStatementBuilder;
import org.apache.flink.connector.jdbc.internal.executor.KeyedBatchStatementExecutor;
import org.apache.flink.connector.jdbc.internal.executor.SimpleBatchStatementExecutor;

@Internal
public interface JdbcBatchStatementExecutor<T> {
    public void prepareStatements(Connection var1) throws SQLException;

    public void addToBatch(T var1) throws SQLException;

    public void executeBatch() throws SQLException;

    public void closeStatements() throws SQLException;

    public static <T, K> JdbcBatchStatementExecutor<T> keyed(String sql, Function<T, K> keyExtractor, JdbcStatementBuilder<K> statementBuilder) {
        return new KeyedBatchStatementExecutor<T, K>(sql, keyExtractor, statementBuilder);
    }

    public static <T> JdbcBatchStatementExecutor<T> simple(String sql, JdbcStatementBuilder<T> paramSetter) {
        return new SimpleBatchStatementExecutor<T>(sql, paramSetter);
    }
}

