/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.jdbc.JdbcStatementBuilder;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimpleBatchStatementExecutor<T>
implements JdbcBatchStatementExecutor<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleBatchStatementExecutor.class);
    private final String sql;
    private final JdbcStatementBuilder<T> parameterSetter;
    private final List<T> batch;
    private transient PreparedStatement st;

    SimpleBatchStatementExecutor(String sql, JdbcStatementBuilder<T> statementBuilder) {
        this.sql = sql;
        this.parameterSetter = statementBuilder;
        this.batch = new ArrayList<T>();
    }

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        this.st = connection.prepareStatement(this.sql);
    }

    @Override
    public void addToBatch(T record) {
        this.batch.add(record);
    }

    @Override
    public void executeBatch() throws SQLException {
        if (!this.batch.isEmpty()) {
            for (T r : this.batch) {
                this.parameterSetter.accept(this.st, r);
                this.st.addBatch();
            }
            this.st.executeBatch();
            this.batch.clear();
        }
    }

    @Override
    public void closeStatements() throws SQLException {
        if (this.st != null) {
            this.st.close();
            this.st = null;
        }
    }
}

