/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.trino.database.dialect;

import java.math.BigDecimal;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.database.dialect.AbstractDialectConverter;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class TrinoDialectConverter
extends AbstractDialectConverter {
    private static final long serialVersionUID = 1L;

    public TrinoDialectConverter(RowType rowType) {
        super(rowType);
    }

    @Override
    public AbstractDialectConverter.JdbcDeserializationConverter createInternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BIGINT: {
                return val -> val instanceof Number ? Long.valueOf(((Number)val).longValue()) : val;
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                return val -> val instanceof Number ? DecimalData.fromBigDecimal((BigDecimal)BigDecimal.valueOf(((Number)val).doubleValue()), (int)precision, (int)scale) : val;
            }
        }
        return super.createInternalConverter(type);
    }

    @Override
    public String converterName() {
        return "Trino";
    }
}

