/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.xa;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.jdbc.xa.XaFacade;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@NotThreadSafe
@Internal
class XaFacadeImpl
implements XaFacade {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(XaFacadeImpl.class);
    private static final Set<Integer> TRANSIENT_ERR_CODES = new HashSet<Integer>(Arrays.asList(107, -7));
    private static final Set<Integer> HEUR_ERR_CODES = new HashSet<Integer>(Arrays.asList(6, 7, 8, 5));
    private static final int MAX_RECOVER_CALLS = 100;
    private final Supplier<XADataSource> dataSourceSupplier;
    private final Integer timeoutSec;
    private transient XAResource xaResource;
    private transient Connection connection;
    private transient XAConnection xaConnection;

    @VisibleForTesting
    static XaFacadeImpl fromXaDataSource(XADataSource ds) {
        return new XaFacadeImpl(() -> ds, null);
    }

    XaFacadeImpl(Supplier<XADataSource> dataSourceSupplier, Integer timeoutSec) {
        this.dataSourceSupplier = (Supplier)Preconditions.checkNotNull(dataSourceSupplier);
        this.timeoutSec = timeoutSec;
    }

    @Override
    public void open() throws SQLException {
        Preconditions.checkState((!this.isOpen() ? 1 : 0) != 0, (Object)"already connected");
        XADataSource ds = this.dataSourceSupplier.get();
        this.xaConnection = ds.getXAConnection();
        this.xaResource = this.xaConnection.getXAResource();
        if (this.timeoutSec != null) {
            try {
                this.xaResource.setTransactionTimeout(this.timeoutSec);
            }
            catch (XAException e) {
                throw new SQLException(e);
            }
        }
        this.connection = this.xaConnection.getConnection();
        this.connection.setReadOnly(false);
        this.connection.setAutoCommit(false);
        Preconditions.checkState((!this.connection.getAutoCommit() ? 1 : 0) != 0);
    }

    @Override
    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        try {
            this.xaConnection.close();
        }
        catch (SQLException e) {
            LOG.warn("unable to close XA connection", (Throwable)e);
        }
        this.xaResource = null;
    }

    @Override
    public Connection getConnection() {
        Preconditions.checkNotNull((Object)this.connection);
        return this.connection;
    }

    @Override
    public boolean isConnectionValid() throws SQLException {
        return this.isOpen() && this.connection.isValid(this.connection.getNetworkTimeout());
    }

    @Override
    public Connection getOrEstablishConnection() throws SQLException {
        if (!this.isOpen()) {
            this.open();
        }
        return this.connection;
    }

    @Override
    public void closeConnection() {
        try {
            this.close();
        }
        catch (SQLException e) {
            LOG.warn("Connection close failed.", (Throwable)e);
        }
    }

    @Override
    public Connection reestablishConnection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void start(Xid xid) {
        this.execute(Command.fromRunnable("start", xid, (ThrowingRunnable<XAException>)((ThrowingRunnable)() -> this.xaResource.start(xid, 0))));
    }

    @Override
    public void endAndPrepare(Xid xid) {
        this.execute(Command.fromRunnable("end", xid, (ThrowingRunnable<XAException>)((ThrowingRunnable)() -> this.xaResource.end(xid, 0x4000000))));
        int prepResult = (Integer)this.execute(new Command("prepare", (Optional)Optional.of(xid), () -> this.xaResource.prepare(xid)));
        if (prepResult == 3) {
            throw new XaFacade.EmptyXaTransactionException(xid);
        }
        if (prepResult != 0) {
            throw new FlinkRuntimeException(XaFacadeImpl.formatErrorMessage("prepare", Optional.of(xid), Optional.empty(), "response: " + prepResult));
        }
    }

    @Override
    public void failAndRollback(Xid xid) {
        this.execute(Command.fromRunnable("end (fail)", xid, (ThrowingRunnable<XAException>)() -> {
            this.xaResource.end(xid, 0x20000000);
            this.xaResource.rollback(xid);
        }, err -> {
            if (err.errorCode >= 100) {
                this.rollback(xid);
            } else {
                XaFacadeImpl.LOG.warn(XaFacadeImpl.formatErrorMessage("end (fail)", Optional.of(xid), Optional.of(err.errorCode), new String[0]));
            }
        }));
    }

    @Override
    public void commit(Xid xid, boolean ignoreUnknown) {
        this.execute(Command.fromRunnableRecoverByWarn("commit", xid, (ThrowingRunnable<XAException>)((ThrowingRunnable)() -> this.xaResource.commit(xid, false)), e -> this.buildCommitErrorDesc((XAException)e, ignoreUnknown)));
    }

    @Override
    public void rollback(Xid xid) {
        this.execute(Command.fromRunnableRecoverByWarn("rollback", xid, (ThrowingRunnable<XAException>)((ThrowingRunnable)() -> this.xaResource.rollback(xid)), this::buildRollbackErrorDesc));
    }

    private void forget(Xid xid) {
        this.execute(Command.fromRunnableRecoverByWarn("forget", xid, (ThrowingRunnable<XAException>)((ThrowingRunnable)() -> this.xaResource.forget(xid)), e -> Optional.of("manual cleanup may be required")));
    }

    @Override
    public Collection<Xid> recover() {
        return (Collection)this.execute(new Command("recover", Optional.empty(), () -> {
            List<Xid> list = this.recover(0x1000000);
            try {
                int i = 0;
                while (list.addAll(this.recover(0))) {
                    Preconditions.checkState((i < 100 ? 1 : 0) != 0, (Object)"too many xa_recover() calls");
                    ++i;
                }
            }
            finally {
                this.recover(0x800000);
            }
            return list;
        }));
    }

    @Override
    public boolean isOpen() {
        return this.xaResource != null;
    }

    private List<Xid> recover(int flags) throws XAException {
        return Arrays.asList(this.xaResource.recover(flags));
    }

    private <T> T execute(Command<T> cmd) throws FlinkRuntimeException {
        Preconditions.checkState((boolean)this.isOpen(), (Object)"not connected");
        LOG.debug("{}, xid={}", (Object)cmd.name, (Object)cmd.xid);
        try {
            Object result = cmd.callable.call();
            LOG.trace("{} succeeded , xid={}", (Object)cmd.name, (Object)cmd.xid);
            return (T)result;
        }
        catch (XAException e) {
            if (HEUR_ERR_CODES.contains(e.errorCode)) {
                cmd.xid.ifPresent(this::forget);
            }
            return ((Optional)cmd.recover.apply(e)).orElseThrow(() -> XaFacadeImpl.wrapException(cmd.name, cmd.xid, e));
        }
        catch (FlinkRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw XaFacadeImpl.wrapException(cmd.name, cmd.xid, e);
        }
    }

    private static FlinkRuntimeException wrapException(String action, Optional<Xid> xid, Exception ex) {
        if (ex instanceof XAException) {
            XAException xa = (XAException)ex;
            if (TRANSIENT_ERR_CODES.contains(xa.errorCode)) {
                throw new XaFacade.TransientXaException(xa);
            }
            throw new FlinkRuntimeException(XaFacadeImpl.formatErrorMessage(action, xid, Optional.of(xa.errorCode), xa.getMessage()));
        }
        throw new FlinkRuntimeException(XaFacadeImpl.formatErrorMessage(action, xid, Optional.empty(), ex.getMessage()), (Throwable)ex);
    }

    private Optional<String> buildCommitErrorDesc(XAException err, boolean ignoreUnknown) {
        if (err.errorCode == 7) {
            return Optional.of("transaction was heuristically committed earlier");
        }
        if (ignoreUnknown && err.errorCode == -4) {
            return Optional.of("transaction is unknown to RM (ignoring)");
        }
        return Optional.empty();
    }

    private Optional<String> buildRollbackErrorDesc(XAException err) {
        if (err.errorCode == 6) {
            return Optional.of("transaction was already heuristically rolled back");
        }
        if (err.errorCode >= 100) {
            return Optional.of("transaction was already marked for rollback");
        }
        return Optional.empty();
    }

    private static String formatErrorMessage(String action, Optional<Xid> xid, Optional<Integer> errorCode, String ... more) {
        return String.format("unable to %s%s%s%s", action, xid.map(x -> " XA transaction, xid: " + x).orElse(""), errorCode.map(code -> String.format(", error %d: %s", code, XaFacadeImpl.descError(code))).orElse(""), more == null || more.length == 0 ? "" : ". " + Arrays.toString(more));
    }

    private static String descError(int code) {
        switch (code) {
            case 7: {
                return "heuristic commit decision was made";
            }
            case 8: {
                return "heuristic decision may have been made";
            }
            case 5: {
                return "heuristic mixed decision was made";
            }
            case 6: {
                return "heuristic rollback decision was made";
            }
            case 9: {
                return "the transaction resumption must happen where the suspension occurred";
            }
            case 101: {
                return "rollback happened due to a communications failure";
            }
            case 102: {
                return "rollback happened because deadlock was detected";
            }
            case 103: {
                return "rollback happened because an internal integrity check failed";
            }
            case 104: {
                return "rollback happened for some reason not fitting any of the other rollback error codes";
            }
            case 105: {
                return "rollback happened due to a protocol error in the resource manager";
            }
            case 100: {
                return "rollback happened for an unspecified reason";
            }
            case 106: {
                return "rollback happened because of a timeout";
            }
            case 107: {
                return "rollback happened due to a transient failure";
            }
            case 3: {
                return "the transaction branch was read-only, and has already been committed";
            }
            case 4: {
                return "the method invoked returned without having any effect, and that it may be invoked again";
            }
            case -2: {
                return "an asynchronous operation is outstanding";
            }
            case -8: {
                return "Xid given as an argument is already known to the resource manager";
            }
            case -5: {
                return "invalid arguments were passed";
            }
            case -4: {
                return "Xid is not valid";
            }
            case -9: {
                return "the resource manager is doing work outside the global transaction";
            }
            case -6: {
                return "protocol error";
            }
            case -3: {
                return "resource manager error has occurred";
            }
            case -7: {
                return "the resource manager has failed and is not available";
            }
        }
        return "";
    }

    private static class Command<T> {
        private final String name;
        private final Optional<Xid> xid;
        private final Callable<T> callable;
        private final Function<XAException, Optional<T>> recover;

        static Command<Object> fromRunnable(String action, Xid xid, ThrowingRunnable<XAException> runnable) {
            return Command.fromRunnable(action, xid, runnable, e -> {
                throw XaFacadeImpl.wrapException(action, Optional.of(xid), e);
            });
        }

        static Command<Object> fromRunnableRecoverByWarn(String action, Xid xid, ThrowingRunnable<XAException> runnable, Function<XAException, Optional<String>> err2msg) {
            return Command.fromRunnable(action, xid, runnable, e -> LOG.warn(XaFacadeImpl.formatErrorMessage(action, Optional.of(xid), Optional.of(e.errorCode), new String[]{(String)((Optional)err2msg.apply((XAException)e)).orElseThrow(() -> XaFacadeImpl.wrapException(action, Optional.of(xid), e))})));
        }

        private static Command<Object> fromRunnable(String action, Xid xid, ThrowingRunnable<XAException> runnable, Consumer<XAException> recover) {
            return new Command<Object>(action, Optional.of(xid), () -> {
                runnable.run();
                return null;
            }, e -> {
                recover.accept((XAException)e);
                return Optional.of("");
            });
        }

        private Command(String name, Optional<Xid> xid, Callable<T> callable) {
            this(name, xid, callable, (XAException e) -> Optional.empty());
        }

        private Command(String name, Optional<Xid> xid, Callable<T> callable, Function<XAException, Optional<T>> recover) {
            this.name = name;
            this.xid = xid;
            this.callable = callable;
            this.recover = recover;
        }
    }
}

