/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.xa;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.transaction.xa.Xid;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.xa.XaFacade;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Internal
class XaFacadePoolingImpl
implements XaFacade {
    private static final long serialVersionUID = 1L;
    private static final transient Logger LOG = LoggerFactory.getLogger(XaFacadePoolingImpl.class);
    private final FacadeSupplier facadeSupplier;
    private transient XaFacade active;
    private transient Map<Xid, XaFacade> mappedToXids;
    private transient Deque<XaFacade> pooled;

    XaFacadePoolingImpl(FacadeSupplier facadeSupplier) {
        this.facadeSupplier = facadeSupplier;
    }

    @Override
    public void open() throws Exception {
        Preconditions.checkState((this.active == null ? 1 : 0) != 0);
        this.pooled = new LinkedList<XaFacade>();
        this.mappedToXids = new HashMap<Xid, XaFacade>();
    }

    @Override
    public boolean isOpen() {
        return this.active != null && this.active.isOpen();
    }

    @Override
    public void start(Xid xid) throws Exception {
        Preconditions.checkState((this.active == null ? 1 : 0) != 0);
        if (this.pooled.isEmpty()) {
            this.active = (XaFacade)this.facadeSupplier.get();
            this.active.open();
        } else {
            this.active = this.pooled.poll();
        }
        this.active.start(xid);
        this.mappedToXids.put(xid, this.active);
    }

    @Override
    public void endAndPrepare(Xid xid) throws Exception {
        Preconditions.checkState((this.active == this.mappedToXids.get(xid) ? 1 : 0) != 0);
        try {
            this.active.endAndPrepare(xid);
        }
        finally {
            this.active = null;
        }
    }

    @Override
    public void commit(Xid xid, boolean ignoreUnknown) throws XaFacade.TransientXaException {
        this.runForXid(xid, (ThrowingConsumer<XaFacade, XaFacade.TransientXaException>)((ThrowingConsumer)facade -> facade.commit(xid, ignoreUnknown)));
    }

    @Override
    public void rollback(Xid xid) throws XaFacade.TransientXaException {
        this.runForXid(xid, (ThrowingConsumer<XaFacade, XaFacade.TransientXaException>)((ThrowingConsumer)facade -> facade.rollback(xid)));
    }

    @Override
    public void failAndRollback(Xid xid) throws XaFacade.TransientXaException {
        this.runForXid(xid, (ThrowingConsumer<XaFacade, XaFacade.TransientXaException>)((ThrowingConsumer)facade -> facade.failAndRollback(xid)));
    }

    @Override
    public Collection<Xid> recover() throws XaFacade.TransientXaException {
        return this.peekPooled().recover();
    }

    @Override
    public void close() throws Exception {
        for (XaFacade facade : this.mappedToXids.values()) {
            facade.close();
        }
        for (XaFacade facade : this.pooled) {
            facade.close();
        }
        if (this.active != null && this.active.isOpen()) {
            this.active.close();
        }
    }

    @Override
    @Nullable
    public Connection getConnection() {
        return this.active.getConnection();
    }

    @Override
    public boolean isConnectionValid() throws SQLException {
        return this.active.isConnectionValid();
    }

    @Override
    public Connection getOrEstablishConnection() throws SQLException, ClassNotFoundException {
        return this.active.getOrEstablishConnection();
    }

    @Override
    public void closeConnection() {
        this.active.closeConnection();
    }

    @Override
    public Connection reestablishConnection() throws SQLException, ClassNotFoundException {
        return this.active.reestablishConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runForXid(Xid xid, ThrowingConsumer<XaFacade, XaFacade.TransientXaException> action) {
        XaFacade mapped = this.mappedToXids.remove(xid);
        if (mapped == null) {
            LOG.debug("No XA resource found associated with XID: {}", (Object)xid);
            action.accept((Object)this.peekPooled());
        } else {
            LOG.debug("Found mapped XA resource for XID: {} {}", (Object)xid, (Object)mapped);
            try {
                action.accept((Object)mapped);
            }
            finally {
                this.pooled.offer(mapped);
            }
        }
    }

    private XaFacade peekPooled() {
        XaFacade xaFacade = this.pooled.peek();
        if (xaFacade == null) {
            xaFacade = (XaFacade)this.facadeSupplier.get();
            try {
                xaFacade.open();
            }
            catch (Exception e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
            this.pooled.offer(xaFacade);
        }
        return xaFacade;
    }

    public static interface FacadeSupplier
    extends Serializable,
    Supplier<XaFacade> {
    }
}

