/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.watermark;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.watermark.BoolWatermarkDeclaration;
import org.apache.flink.api.common.watermark.LongWatermarkDeclaration;
import org.apache.flink.api.common.watermark.WatermarkCombinationFunction;
import org.apache.flink.api.common.watermark.WatermarkCombinationPolicy;
import org.apache.flink.api.common.watermark.WatermarkHandlingStrategy;

@Experimental
public class WatermarkDeclarations {
    public static WatermarkDeclarationBuilder newBuilder(String identifier) {
        return new WatermarkDeclarationBuilder(identifier);
    }

    @Experimental
    public static class WatermarkDeclarationBuilder {
        protected final String identifier;

        WatermarkDeclarationBuilder(String identifier) {
            this.identifier = identifier;
        }

        public LongWatermarkDeclarationBuilder typeLong() {
            return new LongWatermarkDeclarationBuilder(this.identifier);
        }

        public BoolWatermarkDeclarationBuilder typeBool() {
            return new BoolWatermarkDeclarationBuilder(this.identifier);
        }

        @Experimental
        public static class BoolWatermarkDeclarationBuilder {
            private final String identifier;
            private boolean combineWaitForAllChannels = false;
            private WatermarkCombinationFunction combinationFunction = WatermarkCombinationFunction.BoolWatermarkCombinationFunction.AND;
            private WatermarkHandlingStrategy defaultHandlingStrategy = WatermarkHandlingStrategy.FORWARD;

            public BoolWatermarkDeclarationBuilder(String identifier) {
                this.identifier = identifier;
            }

            public BoolWatermarkDeclarationBuilder combineFunctionOR() {
                this.combinationFunction = WatermarkCombinationFunction.BoolWatermarkCombinationFunction.OR;
                return this;
            }

            public BoolWatermarkDeclarationBuilder combineFunctionAND() {
                this.combinationFunction = WatermarkCombinationFunction.BoolWatermarkCombinationFunction.AND;
                return this;
            }

            public BoolWatermarkDeclarationBuilder defaultHandlingStrategy(WatermarkHandlingStrategy strategy) {
                this.defaultHandlingStrategy = strategy;
                return this;
            }

            public BoolWatermarkDeclarationBuilder defaultHandlingStrategyForward() {
                this.defaultHandlingStrategy = WatermarkHandlingStrategy.FORWARD;
                return this;
            }

            public BoolWatermarkDeclarationBuilder defaultHandlingStrategyIgnore() {
                this.defaultHandlingStrategy = WatermarkHandlingStrategy.IGNORE;
                return this;
            }

            public BoolWatermarkDeclarationBuilder combineWaitForAllChannels(boolean combineWaitForAllChannels) {
                this.combineWaitForAllChannels = combineWaitForAllChannels;
                return this;
            }

            public BoolWatermarkDeclaration build() {
                return new BoolWatermarkDeclaration(this.identifier, new WatermarkCombinationPolicy(this.combinationFunction, this.combineWaitForAllChannels), this.defaultHandlingStrategy);
            }
        }

        @Experimental
        public static class LongWatermarkDeclarationBuilder {
            private final String identifier;
            private boolean combineWaitForAllChannels = false;
            private WatermarkCombinationFunction combinationFunction = WatermarkCombinationFunction.NumericWatermarkCombinationFunction.MIN;
            private WatermarkHandlingStrategy defaultHandlingStrategy = WatermarkHandlingStrategy.FORWARD;

            public LongWatermarkDeclarationBuilder(String identifier) {
                this.identifier = identifier;
            }

            public LongWatermarkDeclarationBuilder combineFunctionMax() {
                this.combinationFunction = WatermarkCombinationFunction.NumericWatermarkCombinationFunction.MAX;
                return this;
            }

            public LongWatermarkDeclarationBuilder combineFunctionMin() {
                this.combinationFunction = WatermarkCombinationFunction.NumericWatermarkCombinationFunction.MIN;
                return this;
            }

            public LongWatermarkDeclarationBuilder defaultHandlingStrategy(WatermarkHandlingStrategy strategy) {
                this.defaultHandlingStrategy = strategy;
                return this;
            }

            public LongWatermarkDeclarationBuilder defaultHandlingStrategyForward() {
                this.defaultHandlingStrategy = WatermarkHandlingStrategy.FORWARD;
                return this;
            }

            public LongWatermarkDeclarationBuilder defaultHandlingStrategyIgnore() {
                this.defaultHandlingStrategy = WatermarkHandlingStrategy.IGNORE;
                return this;
            }

            public LongWatermarkDeclarationBuilder combineWaitForAllChannels(boolean combineWaitForAllChannels) {
                this.combineWaitForAllChannels = combineWaitForAllChannels;
                return this;
            }

            public LongWatermarkDeclaration build() {
                return new LongWatermarkDeclaration(this.identifier, new WatermarkCombinationPolicy(this.combinationFunction, this.combineWaitForAllChannels), this.defaultHandlingStrategy);
            }
        }
    }
}

