/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.Visitable;
import org.apache.flink.util.Visitor;

@Internal
public class Plan
implements Visitable<Operator<?>> {
    protected final List<GenericDataSinkBase<?>> sinks = new ArrayList(4);
    protected String jobName;
    protected int defaultParallelism = -1;
    protected HashMap<String, DistributedCache.DistributedCacheEntry> cacheFile = new HashMap();
    protected ExecutionConfig executionConfig;
    private JobID jobId;
    private long sessionTimeout;

    public Plan(Collection<? extends GenericDataSinkBase<?>> sinks, String jobName) {
        this(sinks, jobName, -1);
    }

    public Plan(Collection<? extends GenericDataSinkBase<?>> sinks, String jobName, int defaultParallelism) {
        this.sinks.addAll(sinks);
        this.jobName = jobName;
        this.defaultParallelism = defaultParallelism;
    }

    public Plan(GenericDataSinkBase<?> sink, String jobName) {
        this(sink, jobName, -1);
    }

    public Plan(GenericDataSinkBase<?> sink, String jobName, int defaultParallelism) {
        this(Collections.singletonList(sink), jobName, defaultParallelism);
    }

    public Plan(Collection<? extends GenericDataSinkBase<?>> sinks) {
        this(sinks, -1);
    }

    public Plan(Collection<? extends GenericDataSinkBase<?>> sinks, int defaultParallelism) {
        this(sinks, "Flink Job at " + Calendar.getInstance().getTime(), defaultParallelism);
    }

    public Plan(GenericDataSinkBase<?> sink) {
        this(sink, -1);
    }

    public Plan(GenericDataSinkBase<?> sink, int defaultParallelism) {
        this(sink, "Flink Job at " + Calendar.getInstance().getTime(), defaultParallelism);
    }

    public void addDataSink(GenericDataSinkBase<?> sink) {
        Preconditions.checkNotNull(this.jobName, "The data sink must not be null.");
        if (!this.sinks.contains(sink)) {
            this.sinks.add(sink);
        }
    }

    public Collection<? extends GenericDataSinkBase<?>> getDataSinks() {
        return this.sinks;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        Preconditions.checkNotNull(jobName, "The job name must not be null.");
        this.jobName = jobName;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public void setJobId(JobID jobId) {
        this.jobId = jobId;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public int getDefaultParallelism() {
        return this.defaultParallelism;
    }

    public void setDefaultParallelism(int defaultParallelism) {
        Preconditions.checkArgument(defaultParallelism >= 1 || defaultParallelism == -1, "The default parallelism must be positive, or ExecutionConfig.PARALLELISM_DEFAULT if the system should use the globally configured default.");
        this.defaultParallelism = defaultParallelism;
    }

    public String getPostPassClassName() {
        return "org.apache.flink.optimizer.postpass.JavaApiPostPass";
    }

    public ExecutionConfig getExecutionConfig() {
        if (this.executionConfig == null) {
            throw new RuntimeException("Execution config has not been set properly for this plan");
        }
        return this.executionConfig;
    }

    public void setExecutionConfig(ExecutionConfig executionConfig) {
        this.executionConfig = executionConfig;
    }

    @Override
    public void accept(Visitor<Operator<?>> visitor) {
        for (GenericDataSinkBase<?> sink : this.sinks) {
            sink.accept(visitor);
        }
    }

    public void registerCachedFile(String name, DistributedCache.DistributedCacheEntry entry) throws IOException {
        if (!this.cacheFile.containsKey(name)) {
            try {
                FileSystem fs;
                URI u = new URI(entry.filePath);
                if (!u.getPath().startsWith("/")) {
                    u = new File(entry.filePath).toURI();
                }
                if (!(fs = FileSystem.get(u)).exists(new Path(u.getPath()))) {
                    throw new IOException("File " + u.toString() + " doesn't exist.");
                }
                this.cacheFile.put(name, new DistributedCache.DistributedCacheEntry(u.toString(), entry.isExecutable));
            }
            catch (URISyntaxException ex) {
                throw new IOException("Invalid path: " + entry.filePath, ex);
            }
        } else {
            throw new IOException("cache file " + name + "already exists!");
        }
    }

    public Set<Map.Entry<String, DistributedCache.DistributedCacheEntry>> getCachedFiles() {
        return this.cacheFile.entrySet();
    }

    public int getMaximumParallelism() {
        MaxDopVisitor visitor = new MaxDopVisitor();
        this.accept(visitor);
        return Math.max(visitor.maxDop, this.defaultParallelism);
    }

    private static final class MaxDopVisitor
    implements Visitor<Operator<?>> {
        private int maxDop = -1;

        private MaxDopVisitor() {
        }

        @Override
        public boolean preVisit(Operator<?> visitable) {
            this.maxDop = Math.max(this.maxDop, visitable.getParallelism());
            return true;
        }

        @Override
        public void postVisit(Operator<?> visitable) {
        }
    }
}

