/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public class TaskInfo {
    private final String taskName;
    private final String taskNameWithSubtasks;
    private final int indexOfSubtask;
    private final int numberOfParallelSubtasks;
    private final int attemptNumber;

    public TaskInfo(String taskName, int indexOfSubtask, int numberOfParallelSubtasks, int attemptNumber) {
        Preconditions.checkArgument(indexOfSubtask >= 0, "Task index must be a non-negative number.");
        Preconditions.checkArgument(numberOfParallelSubtasks >= 1, "Parallelism must be a positive number.");
        Preconditions.checkArgument(indexOfSubtask < numberOfParallelSubtasks, "Task index must be less than parallelism.");
        Preconditions.checkArgument(attemptNumber >= 0, "Attempt number must be a non-negative number.");
        this.taskName = Preconditions.checkNotNull(taskName, "Task Name must not be null.");
        this.indexOfSubtask = indexOfSubtask;
        this.numberOfParallelSubtasks = numberOfParallelSubtasks;
        this.attemptNumber = attemptNumber;
        this.taskNameWithSubtasks = taskName + " (" + (indexOfSubtask + 1) + '/' + numberOfParallelSubtasks + ')';
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getIndexOfThisSubtask() {
        return this.indexOfSubtask;
    }

    public int getNumberOfParallelSubtasks() {
        return this.numberOfParallelSubtasks;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public String getTaskNameWithSubtasks() {
        return this.taskNameWithSubtasks;
    }
}

