/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.util.SerializedValue;

@Internal
public class AccumulatorHelper {
    public static void mergeInto(Map<String, Accumulator<?, ?>> target, Map<String, Accumulator<?, ?>> toMerge) {
        for (Map.Entry<String, Accumulator<?, ?>> otherEntry : toMerge.entrySet()) {
            Accumulator<?, ?> ownAccumulator = target.get(otherEntry.getKey());
            if (ownAccumulator == null) {
                target.put(otherEntry.getKey(), otherEntry.getValue().clone());
                continue;
            }
            AccumulatorHelper.compareAccumulatorTypes(otherEntry.getKey(), ownAccumulator.getClass(), otherEntry.getValue().getClass());
            AccumulatorHelper.mergeSingle(ownAccumulator, otherEntry.getValue());
        }
    }

    private static <V, R extends Serializable> void mergeSingle(Accumulator<?, ?> target, Accumulator<?, ?> toMerge) {
        Accumulator<?, ?> typedTarget = target;
        Accumulator<?, ?> typedToMerge = toMerge;
        typedTarget.merge(typedToMerge);
    }

    public static void compareAccumulatorTypes(Object name, Class<? extends Accumulator> first, Class<? extends Accumulator> second) throws UnsupportedOperationException {
        if (first == null || second == null) {
            throw new NullPointerException();
        }
        if (first != second) {
            if (!first.getName().equals(second.getName())) {
                throw new UnsupportedOperationException("The accumulator object '" + name + "' was created with two different types: " + first.getName() + " and " + second.getName());
            }
            throw new UnsupportedOperationException("The accumulator object '" + name + "' was created with two different classes: " + first + " and " + second + " Both have the same type (" + first.getName() + ") but different classloaders: " + first.getClassLoader() + " and " + second.getClassLoader());
        }
    }

    public static Map<String, Object> toResultMap(Map<String, Accumulator<?, ?>> accumulators) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Accumulator<?, ?>> entry : accumulators.entrySet()) {
            resultMap.put(entry.getKey(), entry.getValue().getLocalValue());
        }
        return resultMap;
    }

    public static String getResultsFormated(Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            builder.append("- ").append(entry.getKey()).append(" (").append(entry.getValue().getClass().getName());
            builder.append(")").append(": ").append(entry.getValue().toString()).append("\n");
        }
        return builder.toString();
    }

    public static void resetAndClearAccumulators(Map<String, Accumulator<?, ?>> accumulators) {
        if (accumulators != null) {
            for (Map.Entry<String, Accumulator<?, ?>> entry : accumulators.entrySet()) {
                entry.getValue().resetLocal();
            }
            accumulators.clear();
        }
    }

    public static Map<String, Accumulator<?, ?>> copy(Map<String, Accumulator<?, ?>> accumulators) {
        HashMap result = new HashMap();
        for (Map.Entry<String, Accumulator<?, ?>> entry : accumulators.entrySet()) {
            result.put(entry.getKey(), entry.getValue().clone());
        }
        return result;
    }

    public static Map<String, Object> deserializeAccumulators(Map<String, SerializedValue<Object>> serializedAccumulators, ClassLoader loader) throws IOException, ClassNotFoundException {
        if (serializedAccumulators == null || serializedAccumulators.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> accumulators = new HashMap<String, Object>(serializedAccumulators.size());
        for (Map.Entry<String, SerializedValue<Object>> entry : serializedAccumulators.entrySet()) {
            Object value = null;
            if (entry.getValue() != null) {
                value = entry.getValue().deserializeValue(loader);
            }
            accumulators.put(entry.getKey(), value);
        }
        return accumulators;
    }
}

