/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.StateBackend;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;

@PublicEvolving
public class ReducingStateDescriptor<T>
extends StateDescriptor<ReducingState<T>, T> {
    private static final long serialVersionUID = 1L;
    private final ReduceFunction<T> reduceFunction;

    public ReducingStateDescriptor(String name, ReduceFunction<T> reduceFunction, Class<T> typeClass) {
        super(name, typeClass, null);
        this.reduceFunction = Objects.requireNonNull(reduceFunction);
        if (reduceFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of ReducingState can not be a RichFunction.");
        }
    }

    public ReducingStateDescriptor(String name, ReduceFunction<T> reduceFunction, TypeInformation<T> typeInfo) {
        super(name, typeInfo, null);
        this.reduceFunction = Objects.requireNonNull(reduceFunction);
    }

    public ReducingStateDescriptor(String name, ReduceFunction<T> reduceFunction, TypeSerializer<T> typeSerializer) {
        super(name, typeSerializer, null);
        this.reduceFunction = Objects.requireNonNull(reduceFunction);
    }

    @Override
    public ReducingState<T> bind(StateBackend stateBackend) throws Exception {
        return stateBackend.createReducingState(this);
    }

    public ReduceFunction<T> getReduceFunction() {
        return this.reduceFunction;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReducingStateDescriptor that = (ReducingStateDescriptor)o;
        return this.serializer.equals(that.serializer) && this.name.equals(that.name);
    }

    @Override
    public int hashCode() {
        int result = this.serializer.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ReducingStateDescriptor{serializer=" + this.serializer + ", reduceFunction=" + this.reduceFunction + '}';
    }
}

