/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.lang.reflect.Array;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public final class GenericArraySerializer<C>
extends TypeSerializer<C[]> {
    private static final long serialVersionUID = 1L;
    private final Class<C> componentClass;
    private final TypeSerializer<C> componentSerializer;
    private transient C[] EMPTY;

    public GenericArraySerializer(Class<C> componentClass, TypeSerializer<C> componentSerializer) {
        this.componentClass = Preconditions.checkNotNull(componentClass);
        this.componentSerializer = Preconditions.checkNotNull(componentSerializer);
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public GenericArraySerializer<C> duplicate() {
        TypeSerializer<C> duplicateComponentSerializer = this.componentSerializer.duplicate();
        if (duplicateComponentSerializer == this.componentSerializer) {
            return this;
        }
        return new GenericArraySerializer<C>(this.componentClass, duplicateComponentSerializer);
    }

    @Override
    public C[] createInstance() {
        if (this.EMPTY == null) {
            this.EMPTY = this.create(0);
        }
        return this.EMPTY;
    }

    @Override
    public C[] copy(C[] from) {
        C[] copy = this.create(from.length);
        for (int i = 0; i < copy.length; ++i) {
            C val = from[i];
            if (val == null) continue;
            copy[i] = this.componentSerializer.copy(val);
        }
        return copy;
    }

    @Override
    public C[] copy(C[] from, C[] reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(C[] value, DataOutputView target) throws IOException {
        target.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            C val = value[i];
            if (val == null) {
                target.writeBoolean(false);
                continue;
            }
            target.writeBoolean(true);
            this.componentSerializer.serialize(val, target);
        }
    }

    @Override
    public C[] deserialize(DataInputView source) throws IOException {
        int len = source.readInt();
        C[] array = this.create(len);
        for (int i = 0; i < len; ++i) {
            boolean isNonNull = source.readBoolean();
            array[i] = isNonNull ? this.componentSerializer.deserialize(source) : null;
        }
        return array;
    }

    @Override
    public C[] deserialize(C[] reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        for (int i = 0; i < len; ++i) {
            boolean isNonNull = source.readBoolean();
            target.writeBoolean(isNonNull);
            if (!isNonNull) continue;
            this.componentSerializer.copy(source, target);
        }
    }

    private final C[] create(int len) {
        return (Object[])Array.newInstance(this.componentClass, len);
    }

    @Override
    public int hashCode() {
        return 31 * this.componentClass.hashCode() + this.componentSerializer.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GenericArraySerializer) {
            GenericArraySerializer other = (GenericArraySerializer)obj;
            return other.canEqual(this) && this.componentClass == other.componentClass && this.componentSerializer.equals(other.componentSerializer);
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof GenericArraySerializer;
    }

    public String toString() {
        return "Serializer " + this.componentClass.getName() + "[]";
    }
}

