/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.io.InputSplit;

@Public
public class LocatableInputSplit
implements InputSplit,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] EMPTY_ARR = new String[0];
    private final int splitNumber;
    private final String[] hostnames;

    public LocatableInputSplit(int splitNumber, String[] hostnames) {
        this.splitNumber = splitNumber;
        this.hostnames = hostnames == null ? EMPTY_ARR : hostnames;
    }

    public LocatableInputSplit(int splitNumber, String hostname) {
        String[] stringArray;
        this.splitNumber = splitNumber;
        if (hostname == null) {
            stringArray = EMPTY_ARR;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = hostname;
        }
        this.hostnames = stringArray;
    }

    @Override
    public int getSplitNumber() {
        return this.splitNumber;
    }

    public String[] getHostnames() {
        return this.hostnames;
    }

    public int hashCode() {
        return this.splitNumber;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof LocatableInputSplit) {
            LocatableInputSplit other = (LocatableInputSplit)obj;
            return other.splitNumber == this.splitNumber && Arrays.deepEquals(other.hostnames, this.hostnames);
        }
        return false;
    }

    public String toString() {
        return "Locatable Split (" + this.splitNumber + ") at " + Arrays.toString(this.hostnames);
    }
}

