/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.MetricRegistry;
import org.apache.flink.metrics.groups.ComponentMetricGroup;
import org.apache.flink.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.metrics.groups.TaskMetricGroup;
import org.apache.flink.metrics.groups.scope.ScopeFormat;
import org.apache.flink.util.AbstractID;

@Internal
public class TaskManagerMetricGroup
extends ComponentMetricGroup {
    private final Map<JobID, TaskManagerJobMetricGroup> jobs = new HashMap<JobID, TaskManagerJobMetricGroup>();
    private final String hostname;
    private final String taskManagerId;

    public TaskManagerMetricGroup(MetricRegistry registry, String hostname, String taskManagerId) {
        this(registry, registry.getScopeFormats().getTaskManagerFormat(), hostname, taskManagerId);
    }

    public TaskManagerMetricGroup(MetricRegistry registry, ScopeFormat.TaskManagerScopeFormat scopeFormat, String hostname, String taskManagerId) {
        super(registry, scopeFormat.formatScope(hostname, taskManagerId));
        this.hostname = hostname;
        this.taskManagerId = taskManagerId;
    }

    public String hostname() {
        return this.hostname;
    }

    public String taskManagerId() {
        return this.taskManagerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskMetricGroup addTaskForJob(JobID jobId, String jobName, AbstractID vertexID, AbstractID executionId, String taskName, int subtaskIndex, int attemptNumber) {
        TaskManagerJobMetricGroup currentJobGroup;
        TaskMetricGroup taskGroup;
        do {
            TaskManagerMetricGroup taskManagerMetricGroup = this;
            synchronized (taskManagerMetricGroup) {
                currentJobGroup = this.jobs.get(jobId);
                if (currentJobGroup == null || currentJobGroup.isClosed()) {
                    currentJobGroup = new TaskManagerJobMetricGroup(this.registry, this, jobId, jobName);
                    this.jobs.put(jobId, currentJobGroup);
                }
            }
        } while ((taskGroup = currentJobGroup.addTask(vertexID, executionId, taskName, subtaskIndex, attemptNumber)) == null);
        return taskGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJobMetricsGroup(JobID jobId, TaskManagerJobMetricGroup group) {
        if (jobId == null || group == null || !group.isClosed()) {
            return;
        }
        TaskManagerMetricGroup taskManagerMetricGroup = this;
        synchronized (taskManagerMetricGroup) {
            TaskManagerJobMetricGroup containedGroup = this.jobs.remove(jobId);
            if (containedGroup != null && containedGroup != group) {
                this.jobs.put(jobId, containedGroup);
            }
        }
    }

    public int numRegisteredJobMetricGroups() {
        return this.jobs.size();
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup> subComponents() {
        return this.jobs.values();
    }
}

