/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.groups.scope;

import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.groups.scope.ScopeFormat;
import org.apache.flink.util.Preconditions;

@Internal
public class ScopeFormats {
    private final ScopeFormat.JobManagerScopeFormat jobManagerFormat;
    private final ScopeFormat.JobManagerJobScopeFormat jobManagerJobFormat;
    private final ScopeFormat.TaskManagerScopeFormat taskManagerFormat;
    private final ScopeFormat.TaskManagerJobScopeFormat taskManagerJobFormat;
    private final ScopeFormat.TaskScopeFormat taskFormat;
    private final ScopeFormat.OperatorScopeFormat operatorFormat;

    public ScopeFormats() {
        this.jobManagerFormat = new ScopeFormat.JobManagerScopeFormat(ScopeFormat.DEFAULT_SCOPE_JOBMANAGER_COMPONENT);
        this.jobManagerJobFormat = new ScopeFormat.JobManagerJobScopeFormat(ScopeFormat.DEFAULT_SCOPE_JOBMANAGER_JOB_GROUP, this.jobManagerFormat);
        this.taskManagerFormat = new ScopeFormat.TaskManagerScopeFormat(ScopeFormat.DEFAULT_SCOPE_TASKMANAGER_COMPONENT);
        this.taskManagerJobFormat = new ScopeFormat.TaskManagerJobScopeFormat(ScopeFormat.DEFAULT_SCOPE_TASKMANAGER_JOB_GROUP, this.taskManagerFormat);
        this.taskFormat = new ScopeFormat.TaskScopeFormat(ScopeFormat.DEFAULT_SCOPE_TASK_GROUP, this.taskManagerJobFormat);
        this.operatorFormat = new ScopeFormat.OperatorScopeFormat(ScopeFormat.DEFAULT_SCOPE_OPERATOR_GROUP, this.taskFormat);
    }

    public ScopeFormats(String jobManagerFormat, String jobManagerJobFormat, String taskManagerFormat, String taskManagerJobFormat, String taskFormat, String operatorFormat) {
        this.jobManagerFormat = new ScopeFormat.JobManagerScopeFormat(jobManagerFormat);
        this.jobManagerJobFormat = new ScopeFormat.JobManagerJobScopeFormat(jobManagerJobFormat, this.jobManagerFormat);
        this.taskManagerFormat = new ScopeFormat.TaskManagerScopeFormat(taskManagerFormat);
        this.taskManagerJobFormat = new ScopeFormat.TaskManagerJobScopeFormat(taskManagerJobFormat, this.taskManagerFormat);
        this.taskFormat = new ScopeFormat.TaskScopeFormat(taskFormat, this.taskManagerJobFormat);
        this.operatorFormat = new ScopeFormat.OperatorScopeFormat(operatorFormat, this.taskFormat);
    }

    public ScopeFormats(ScopeFormat.JobManagerScopeFormat jobManagerFormat, ScopeFormat.JobManagerJobScopeFormat jobManagerJobFormat, ScopeFormat.TaskManagerScopeFormat taskManagerFormat, ScopeFormat.TaskManagerJobScopeFormat taskManagerJobFormat, ScopeFormat.TaskScopeFormat taskFormat, ScopeFormat.OperatorScopeFormat operatorFormat) {
        this.jobManagerFormat = Preconditions.checkNotNull(jobManagerFormat);
        this.jobManagerJobFormat = Preconditions.checkNotNull(jobManagerJobFormat);
        this.taskManagerFormat = Preconditions.checkNotNull(taskManagerFormat);
        this.taskManagerJobFormat = Preconditions.checkNotNull(taskManagerJobFormat);
        this.taskFormat = Preconditions.checkNotNull(taskFormat);
        this.operatorFormat = Preconditions.checkNotNull(operatorFormat);
    }

    public ScopeFormat.JobManagerScopeFormat getJobManagerFormat() {
        return this.jobManagerFormat;
    }

    public ScopeFormat.TaskManagerScopeFormat getTaskManagerFormat() {
        return this.taskManagerFormat;
    }

    public ScopeFormat.TaskManagerJobScopeFormat getTaskManagerJobFormat() {
        return this.taskManagerJobFormat;
    }

    public ScopeFormat.JobManagerJobScopeFormat getJobManagerJobFormat() {
        return this.jobManagerJobFormat;
    }

    public ScopeFormat.TaskScopeFormat getTaskFormat() {
        return this.taskFormat;
    }

    public ScopeFormat.OperatorScopeFormat getOperatorFormat() {
        return this.operatorFormat;
    }
}

