/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import com.esotericsoftware.kryo.Serializer;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.CodeAnalysisMode;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.util.Preconditions;

@Public
public class ExecutionConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int PARALLELISM_AUTO_MAX = Integer.MAX_VALUE;
    public static final int PARALLELISM_DEFAULT = -1;
    private static final long DEFAULT_RESTART_DELAY = 10000L;
    private ExecutionMode executionMode = ExecutionMode.PIPELINED;
    private boolean useClosureCleaner = true;
    private int parallelism = -1;
    @Deprecated
    private int numberOfExecutionRetries = -1;
    private boolean forceKryo = false;
    private boolean objectReuse = false;
    private boolean autoTypeRegistrationEnabled = true;
    private boolean forceAvro = false;
    private CodeAnalysisMode codeAnalysisMode = CodeAnalysisMode.DISABLE;
    private boolean printProgressDuringExecution = true;
    private long autoWatermarkInterval = 0L;
    @Deprecated
    private long executionRetryDelay = 10000L;
    private RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration;
    private long taskCancellationIntervalMillis = -1L;
    private GlobalJobParameters globalJobParameters;
    private LinkedHashMap<Class<?>, SerializableSerializer<?>> registeredTypesWithKryoSerializers = new LinkedHashMap();
    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> registeredTypesWithKryoSerializerClasses = new LinkedHashMap();
    private LinkedHashMap<Class<?>, SerializableSerializer<?>> defaultKryoSerializers = new LinkedHashMap();
    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses = new LinkedHashMap();
    private LinkedHashSet<Class<?>> registeredKryoTypes = new LinkedHashSet();
    private LinkedHashSet<Class<?>> registeredPojoTypes = new LinkedHashSet();

    public ExecutionConfig enableClosureCleaner() {
        this.useClosureCleaner = true;
        return this;
    }

    public ExecutionConfig disableClosureCleaner() {
        this.useClosureCleaner = false;
        return this;
    }

    public boolean isClosureCleanerEnabled() {
        return this.useClosureCleaner;
    }

    @PublicEvolving
    public ExecutionConfig setAutoWatermarkInterval(long interval) {
        this.autoWatermarkInterval = interval;
        return this;
    }

    @PublicEvolving
    public long getAutoWatermarkInterval() {
        return this.autoWatermarkInterval;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public ExecutionConfig setParallelism(int parallelism) {
        Preconditions.checkArgument(parallelism > 0 || parallelism == -1, "The parallelism of an operator must be at least 1.");
        this.parallelism = parallelism;
        return this;
    }

    public long getTaskCancellationInterval() {
        return this.taskCancellationIntervalMillis;
    }

    public ExecutionConfig setTaskCancellationInterval(long interval) {
        this.taskCancellationIntervalMillis = interval;
        return this;
    }

    @PublicEvolving
    public void setRestartStrategy(RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration) {
        this.restartStrategyConfiguration = restartStrategyConfiguration;
    }

    @PublicEvolving
    public RestartStrategies.RestartStrategyConfiguration getRestartStrategy() {
        if (this.restartStrategyConfiguration == null) {
            if (this.getNumberOfExecutionRetries() > 0 && this.getExecutionRetryDelay() >= 0L) {
                return RestartStrategies.fixedDelayRestart(this.getNumberOfExecutionRetries(), this.getExecutionRetryDelay());
            }
            if (this.getNumberOfExecutionRetries() == 0) {
                return RestartStrategies.noRestart();
            }
            return null;
        }
        return this.restartStrategyConfiguration;
    }

    @Deprecated
    public int getNumberOfExecutionRetries() {
        return this.numberOfExecutionRetries;
    }

    @Deprecated
    public long getExecutionRetryDelay() {
        return this.executionRetryDelay;
    }

    @Deprecated
    public ExecutionConfig setNumberOfExecutionRetries(int numberOfExecutionRetries) {
        if (numberOfExecutionRetries < -1) {
            throw new IllegalArgumentException("The number of execution retries must be non-negative, or -1 (use system default)");
        }
        this.numberOfExecutionRetries = numberOfExecutionRetries;
        return this;
    }

    @Deprecated
    public ExecutionConfig setExecutionRetryDelay(long executionRetryDelay) {
        if (executionRetryDelay < 0L) {
            throw new IllegalArgumentException("The delay between retries must be non-negative.");
        }
        this.executionRetryDelay = executionRetryDelay;
        return this;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void enableForceKryo() {
        this.forceKryo = true;
    }

    public void disableForceKryo() {
        this.forceKryo = false;
    }

    public boolean isForceKryoEnabled() {
        return this.forceKryo;
    }

    public void enableForceAvro() {
        this.forceAvro = true;
    }

    public void disableForceAvro() {
        this.forceAvro = false;
    }

    public boolean isForceAvroEnabled() {
        return this.forceAvro;
    }

    public ExecutionConfig enableObjectReuse() {
        this.objectReuse = true;
        return this;
    }

    public ExecutionConfig disableObjectReuse() {
        this.objectReuse = false;
        return this;
    }

    public boolean isObjectReuseEnabled() {
        return this.objectReuse;
    }

    @PublicEvolving
    public void setCodeAnalysisMode(CodeAnalysisMode codeAnalysisMode) {
        this.codeAnalysisMode = codeAnalysisMode;
    }

    @PublicEvolving
    public CodeAnalysisMode getCodeAnalysisMode() {
        return this.codeAnalysisMode;
    }

    public ExecutionConfig enableSysoutLogging() {
        this.printProgressDuringExecution = true;
        return this;
    }

    public ExecutionConfig disableSysoutLogging() {
        this.printProgressDuringExecution = false;
        return this;
    }

    public boolean isSysoutLoggingEnabled() {
        return this.printProgressDuringExecution;
    }

    public GlobalJobParameters getGlobalJobParameters() {
        return this.globalJobParameters;
    }

    public void setGlobalJobParameters(GlobalJobParameters globalJobParameters) {
        this.globalJobParameters = globalJobParameters;
    }

    public <T extends Serializer<?>> void addDefaultKryoSerializer(Class<?> type, T serializer) {
        if (type == null || serializer == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.defaultKryoSerializers.put(type, new SerializableSerializer<T>(serializer));
    }

    public void addDefaultKryoSerializer(Class<?> type, Class<? extends Serializer<?>> serializerClass) {
        if (type == null || serializerClass == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.defaultKryoSerializerClasses.put(type, serializerClass);
    }

    public <T extends Serializer<?>> void registerTypeWithKryoSerializer(Class<?> type, T serializer) {
        if (type == null || serializer == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.registeredTypesWithKryoSerializers.put(type, new SerializableSerializer<T>(serializer));
    }

    public void registerTypeWithKryoSerializer(Class<?> type, Class<? extends Serializer<?>> serializerClass) {
        if (type == null || serializerClass == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.registeredTypesWithKryoSerializerClasses.put(type, serializerClass);
    }

    public void registerPojoType(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        if (!this.registeredPojoTypes.contains(type)) {
            this.registeredPojoTypes.add(type);
        }
    }

    public void registerKryoType(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        this.registeredKryoTypes.add(type);
    }

    public LinkedHashMap<Class<?>, SerializableSerializer<?>> getRegisteredTypesWithKryoSerializers() {
        return this.registeredTypesWithKryoSerializers;
    }

    public LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> getRegisteredTypesWithKryoSerializerClasses() {
        return this.registeredTypesWithKryoSerializerClasses;
    }

    public LinkedHashMap<Class<?>, SerializableSerializer<?>> getDefaultKryoSerializers() {
        return this.defaultKryoSerializers;
    }

    public LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> getDefaultKryoSerializerClasses() {
        return this.defaultKryoSerializerClasses;
    }

    public LinkedHashSet<Class<?>> getRegisteredKryoTypes() {
        if (this.isForceKryoEnabled()) {
            LinkedHashSet result = new LinkedHashSet();
            result.addAll(this.registeredKryoTypes);
            for (Class clazz : this.registeredPojoTypes) {
                if (result.contains(clazz)) continue;
                result.add(clazz);
            }
            return result;
        }
        return this.registeredKryoTypes;
    }

    public LinkedHashSet<Class<?>> getRegisteredPojoTypes() {
        return this.registeredPojoTypes;
    }

    public boolean isAutoTypeRegistrationDisabled() {
        return !this.autoTypeRegistrationEnabled;
    }

    public void disableAutoTypeRegistration() {
        this.autoTypeRegistrationEnabled = false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutionConfig) {
            ExecutionConfig other = (ExecutionConfig)obj;
            return other.canEqual(this) && Objects.equals((Object)this.executionMode, (Object)other.executionMode) && this.useClosureCleaner == other.useClosureCleaner && this.parallelism == other.parallelism && (this.restartStrategyConfiguration == null && other.restartStrategyConfiguration == null || null != this.restartStrategyConfiguration && this.restartStrategyConfiguration.equals(other.restartStrategyConfiguration)) && this.forceKryo == other.forceKryo && this.objectReuse == other.objectReuse && this.autoTypeRegistrationEnabled == other.autoTypeRegistrationEnabled && this.forceAvro == other.forceAvro && Objects.equals((Object)this.codeAnalysisMode, (Object)other.codeAnalysisMode) && this.printProgressDuringExecution == other.printProgressDuringExecution && Objects.equals(this.globalJobParameters, other.globalJobParameters) && this.autoWatermarkInterval == other.autoWatermarkInterval && this.registeredTypesWithKryoSerializerClasses.equals(other.registeredTypesWithKryoSerializerClasses) && this.defaultKryoSerializerClasses.equals(other.defaultKryoSerializerClasses) && this.registeredKryoTypes.equals(other.registeredKryoTypes) && this.registeredPojoTypes.equals(other.registeredPojoTypes) && this.taskCancellationIntervalMillis == other.taskCancellationIntervalMillis;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.executionMode, this.useClosureCleaner, this.parallelism, this.restartStrategyConfiguration, this.forceKryo, this.objectReuse, this.autoTypeRegistrationEnabled, this.forceAvro, this.codeAnalysisMode, this.printProgressDuringExecution, this.globalJobParameters, this.autoWatermarkInterval, this.registeredTypesWithKryoSerializerClasses, this.defaultKryoSerializerClasses, this.registeredKryoTypes, this.registeredPojoTypes, this.taskCancellationIntervalMillis});
    }

    public boolean canEqual(Object obj) {
        return obj instanceof ExecutionConfig;
    }

    public static class GlobalJobParameters
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public Map<String, String> toMap() {
            return Collections.emptyMap();
        }
    }

    public static class SerializableSerializer<T extends Serializer<?>>
    implements Serializable {
        private static final long serialVersionUID = 4687893502781067189L;
        private T serializer;

        public SerializableSerializer(T serializer) {
            this.serializer = serializer;
        }

        public T getSerializer() {
            return this.serializer;
        }
    }
}

