/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;

@Public
public class AverageAccumulator
implements SimpleAccumulator<Double> {
    private static final long serialVersionUID = 3672555084179165255L;
    private double localValue;
    private long count;

    @Override
    public void add(Double value) {
        ++this.count;
        this.localValue += value.doubleValue();
    }

    @Override
    public void add(double value) {
        ++this.count;
        this.localValue += value;
    }

    @Override
    public void add(long value) {
        ++this.count;
        this.localValue += (double)value;
    }

    @Override
    public void add(int value) {
        ++this.count;
        this.localValue += (double)value;
    }

    @Override
    public Double getLocalValue() {
        if (this.count == 0L) {
            return 0.0;
        }
        return this.localValue / (double)this.count;
    }

    @Override
    public void resetLocal() {
        this.count = 0L;
        this.localValue = 0.0;
    }

    @Override
    public void merge(Accumulator<Double, Double> other) {
        if (other instanceof AverageAccumulator) {
            AverageAccumulator temp = (AverageAccumulator)other;
            this.count += temp.count;
            this.localValue += other.getLocalValue().doubleValue();
        } else {
            throw new IllegalArgumentException("The merged accumulator must be AverageAccumulator.");
        }
    }

    public AverageAccumulator clone() {
        AverageAccumulator average = new AverageAccumulator();
        average.localValue = this.localValue;
        average.count = this.count;
        return average;
    }

    public String toString() {
        return "AverageAccumulator " + this.localValue + " count " + this.count;
    }
}

