/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.GenericTypeComparator;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.util.Preconditions;

@Public
public class GenericTypeInfo<T>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = -7959114120287706504L;
    private final Class<T> typeClass;

    @PublicEvolving
    public GenericTypeInfo(Class<T> typeClass) {
        this.typeClass = Preconditions.checkNotNull(typeClass);
    }

    @Override
    @PublicEvolving
    public boolean isBasicType() {
        return false;
    }

    @Override
    @PublicEvolving
    public boolean isTupleType() {
        return false;
    }

    @Override
    @PublicEvolving
    public int getArity() {
        return 1;
    }

    @Override
    @PublicEvolving
    public int getTotalFields() {
        return 1;
    }

    @Override
    @PublicEvolving
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    @PublicEvolving
    public boolean isKeyType() {
        return Comparable.class.isAssignableFrom(this.typeClass);
    }

    @Override
    @PublicEvolving
    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        return new KryoSerializer<T>(this.typeClass, config);
    }

    @Override
    @PublicEvolving
    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        if (this.isKeyType()) {
            GenericTypeComparator<T> comparator = new GenericTypeComparator<T>(sortOrderAscending, this.createSerializer(executionConfig), this.typeClass);
            return comparator;
        }
        throw new UnsupportedOperationException("Types that do not implement java.lang.Comparable cannot be used as keys.");
    }

    @Override
    public int hashCode() {
        return this.typeClass.hashCode();
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof GenericTypeInfo;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof GenericTypeInfo) {
            GenericTypeInfo genericTypeInfo = (GenericTypeInfo)obj;
            return this.typeClass == genericTypeInfo.typeClass;
        }
        return false;
    }

    @Override
    public String toString() {
        return "GenericType<" + this.typeClass.getCanonicalName() + ">";
    }
}

