/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.MetricRegistry;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.groups.GenericMetricGroup;
import org.apache.flink.metrics.groups.scope.ScopeFormat;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractMetricGroup
implements MetricGroup {
    private static final Logger LOG = LoggerFactory.getLogger(MetricGroup.class);
    protected final MetricRegistry registry;
    private final Map<String, Metric> metrics = new HashMap<String, Metric>();
    private final Map<String, MetricGroup> groups = new HashMap<String, MetricGroup>();
    private final String[] scopeComponents;
    private String scopeString;
    private volatile boolean closed;

    public AbstractMetricGroup(MetricRegistry registry, String[] scope) {
        this.registry = Preconditions.checkNotNull(registry);
        this.scopeComponents = Preconditions.checkNotNull(scope);
    }

    public String[] getScopeComponents() {
        return this.scopeComponents;
    }

    public String getMetricIdentifier(String metricName) {
        return this.getMetricIdentifier(metricName, null);
    }

    public String getMetricIdentifier(String metricName, CharacterFilter filter) {
        if (this.scopeString == null) {
            this.scopeString = filter != null ? ScopeFormat.concat(filter, Character.valueOf(this.registry.getDelimiter()), this.scopeComponents) : ScopeFormat.concat(Character.valueOf(this.registry.getDelimiter()), this.scopeComponents);
        }
        if (filter != null) {
            return this.scopeString + this.registry.getDelimiter() + filter.filterCharacters(metricName);
        }
        return this.scopeString + this.registry.getDelimiter() + metricName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AbstractMetricGroup abstractMetricGroup = this;
        synchronized (abstractMetricGroup) {
            if (!this.closed) {
                this.closed = true;
                for (MetricGroup metricGroup : this.groups.values()) {
                    metricGroup.close();
                }
                this.groups.clear();
                for (Map.Entry entry : this.metrics.entrySet()) {
                    this.registry.unregister((Metric)entry.getValue(), (String)entry.getKey(), this);
                }
                this.metrics.clear();
            }
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public Counter counter(int name) {
        return this.counter(String.valueOf(name));
    }

    @Override
    public Counter counter(String name) {
        return this.counter(name, new SimpleCounter());
    }

    @Override
    public <C extends Counter> C counter(int name, C counter) {
        return this.counter(String.valueOf(name), counter);
    }

    @Override
    public <C extends Counter> C counter(String name, C counter) {
        this.addMetric(name, counter);
        return counter;
    }

    @Override
    public <T, G extends Gauge<T>> G gauge(int name, G gauge) {
        return this.gauge(String.valueOf(name), gauge);
    }

    @Override
    public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
        this.addMetric(name, gauge);
        return gauge;
    }

    @Override
    public <H extends Histogram> H histogram(int name, H histogram) {
        return this.histogram(String.valueOf(name), histogram);
    }

    @Override
    public <H extends Histogram> H histogram(String name, H histogram) {
        this.addMetric(name, histogram);
        return histogram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMetric(String name, Metric metric) {
        AbstractMetricGroup abstractMetricGroup = this;
        synchronized (abstractMetricGroup) {
            if (!this.closed) {
                Metric prior = this.metrics.put(name, metric);
                if (prior == null) {
                    if (this.groups.containsKey(name)) {
                        LOG.warn("Name collision: Adding a metric with the same name as a metric subgroup: '" + name + "'. Metric might not get properly reported. (" + this.scopeString + ')');
                    }
                    this.registry.register(metric, name, this);
                } else {
                    this.metrics.put(name, prior);
                    LOG.warn("Name collision: Group already contains a Metric with the name '" + name + "'. Metric will not be reported. (" + this.scopeString + ')');
                }
            }
        }
    }

    @Override
    public MetricGroup addGroup(int name) {
        return this.addGroup(String.valueOf(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetricGroup addGroup(String name) {
        AbstractMetricGroup abstractMetricGroup = this;
        synchronized (abstractMetricGroup) {
            if (!this.closed) {
                GenericMetricGroup newGroup;
                MetricGroup prior;
                if (this.metrics.containsKey(name)) {
                    LOG.warn("Name collision: Adding a metric subgroup with the same name as an existing metric: '" + name + "'. Metric might not get properly reported. (" + this.scopeString + ')');
                }
                if ((prior = this.groups.put(name, newGroup = new GenericMetricGroup(this.registry, this, name))) == null) {
                    return newGroup;
                }
                this.groups.put(name, prior);
                return prior;
            }
            GenericMetricGroup closedGroup = new GenericMetricGroup(this.registry, this, name);
            closedGroup.close();
            return closedGroup;
        }
    }
}

