/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.MetricRegistry;
import org.apache.flink.metrics.groups.ComponentMetricGroup;
import org.apache.flink.metrics.groups.JobMetricGroup;
import org.apache.flink.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.metrics.groups.TaskMetricGroup;
import org.apache.flink.metrics.groups.scope.ScopeFormat;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

@Internal
public class TaskManagerJobMetricGroup
extends JobMetricGroup {
    private final TaskManagerMetricGroup parent;
    private final Map<AbstractID, TaskMetricGroup> tasks = new HashMap<AbstractID, TaskMetricGroup>();

    public TaskManagerJobMetricGroup(MetricRegistry registry, TaskManagerMetricGroup parent, JobID jobId, @Nullable String jobName) {
        this(registry, Preconditions.checkNotNull(parent), registry.getScopeFormats().getTaskManagerJobFormat(), jobId, jobName);
    }

    public TaskManagerJobMetricGroup(MetricRegistry registry, TaskManagerMetricGroup parent, ScopeFormat.TaskManagerJobScopeFormat scopeFormat, JobID jobId, @Nullable String jobName) {
        super(registry, jobId, jobName, scopeFormat.formatScope(parent, jobId, jobName));
        this.parent = Preconditions.checkNotNull(parent);
    }

    public final TaskManagerMetricGroup parent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskMetricGroup addTask(AbstractID vertexId, AbstractID executionId, String taskName, int subtaskIndex, int attemptNumber) {
        Preconditions.checkNotNull(executionId);
        TaskManagerJobMetricGroup taskManagerJobMetricGroup = this;
        synchronized (taskManagerJobMetricGroup) {
            if (!this.isClosed()) {
                TaskMetricGroup task = new TaskMetricGroup(this.registry, this, vertexId, executionId, taskName, subtaskIndex, attemptNumber);
                this.tasks.put(executionId, task);
                return task;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskMetricGroup(AbstractID executionId) {
        Preconditions.checkNotNull(executionId);
        boolean removeFromParent = false;
        TaskManagerJobMetricGroup taskManagerJobMetricGroup = this;
        synchronized (taskManagerJobMetricGroup) {
            if (!this.isClosed() && this.tasks.remove(executionId) != null && this.tasks.isEmpty()) {
                removeFromParent = true;
                this.close();
            }
        }
        if (removeFromParent) {
            this.parent.removeJobMetricsGroup(this.jobId, this);
        }
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup> subComponents() {
        return this.tasks.values();
    }
}

