/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.util.Objects;
import org.apache.flink.annotation.Public;

@Public
public abstract class Either<L, R> {
    public static <L, R> Either<L, R> Left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> Right(R value) {
        return new Right(value);
    }

    public abstract L left() throws IllegalStateException;

    public abstract R right() throws IllegalStateException;

    public final boolean isLeft() {
        return this.getClass() == Left.class;
    }

    public final boolean isRight() {
        return this.getClass() == Right.class;
    }

    public static class Right<L, R>
    extends Either<L, R> {
        private final R value;

        public Right(R value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public L left() {
            throw new IllegalStateException("Cannot retrieve Left value on a Right");
        }

        @Override
        public R right() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object instanceof Right) {
                Right other = (Right)object;
                return this.value.equals(other.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "Right(" + this.value.toString() + ")";
        }

        public static <L, R> Right<L, R> of(R right) {
            return new Right<L, R>(right);
        }
    }

    public static class Left<L, R>
    extends Either<L, R> {
        private final L value;

        public Left(L value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public L left() {
            return this.value;
        }

        @Override
        public R right() {
            throw new IllegalStateException("Cannot retrieve Right value on a Left");
        }

        public boolean equals(Object object) {
            if (object instanceof Left) {
                Left other = (Left)object;
                return this.value.equals(other.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "Left(" + this.value.toString() + ")";
        }

        public static <L, R> Left<L, R> of(L left) {
            return new Left<L, R>(left);
        }
    }
}

