/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class LongValueParser
extends FieldParser<LongValue> {
    private LongValue result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, LongValue reusable) {
        long val = 0L;
        boolean neg = false;
        int delimLimit = limit - delimiter.length + 1;
        this.result = reusable;
        if (bytes[startPos] == 45) {
            neg = true;
            if (++startPos == limit || startPos < delimLimit && LongValueParser.delimiterNext(bytes, startPos, delimiter)) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ORPHAN_SIGN);
                return -1;
            }
        }
        for (int i = startPos; i < limit; ++i) {
            if (i < delimLimit && LongValueParser.delimiterNext(bytes, i, delimiter)) {
                if (i == startPos) {
                    this.setErrorState(FieldParser.ParseErrorState.EMPTY_STRING);
                    return -1;
                }
                reusable.setValue(neg ? -val : val);
                return i + delimiter.length;
            }
            if (bytes[i] < 48 || bytes[i] > 57) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
                return -1;
            }
            val *= 10L;
            if ((val += (long)(bytes[i] - 48)) >= 0L) continue;
            if (neg && val == Long.MIN_VALUE) {
                reusable.setValue(Long.MIN_VALUE);
                if (i + 1 >= limit) {
                    return limit;
                }
                if (i + 1 < delimLimit && LongValueParser.delimiterNext(bytes, i + 1, delimiter)) {
                    return i + 1 + delimiter.length;
                }
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_OVERFLOW_UNDERFLOW);
                return -1;
            }
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_OVERFLOW_UNDERFLOW);
            return -1;
        }
        reusable.setValue(neg ? -val : val);
        return limit;
    }

    @Override
    public LongValue createValue() {
        return new LongValue();
    }

    @Override
    public LongValue getLastResult() {
        return this.result;
    }
}

