/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;

@Internal
public final class InstantiationUtil {
    public static <T> T instantiate(Class<T> clazz, Class<? super T> castTo) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (castTo != null && !castTo.isAssignableFrom(clazz)) {
            throw new RuntimeException("The class '" + clazz.getName() + "' is not a subclass of '" + castTo.getName() + "' as is required.");
        }
        return InstantiationUtil.instantiate(clazz);
    }

    public static <T> T instantiate(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException iex) {
            InstantiationUtil.checkForInstantiation(clazz);
            throw new RuntimeException("Could not instantiate type '" + clazz.getName() + "' due to an unspecified exception: " + iex.getMessage(), iex);
        }
        catch (Throwable t) {
            String message = t.getMessage();
            throw new RuntimeException("Could not instantiate type '" + clazz.getName() + "' Most likely the constructor (or a member variable initialization) threw an exception" + (message == null ? "." : ": " + message), t);
        }
    }

    public static boolean hasPublicNullaryConstructor(Class<?> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isProperClass(Class<?> clazz) {
        int mods = clazz.getModifiers();
        return !Modifier.isAbstract(mods) && !Modifier.isInterface(mods) && !Modifier.isNative(mods);
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return clazz.getEnclosingClass() != null && (clazz.getDeclaringClass() == null || !Modifier.isStatic(clazz.getModifiers()));
    }

    public static void checkForInstantiation(Class<?> clazz) {
        String errorMessage = InstantiationUtil.checkForInstantiationError(clazz);
        if (errorMessage != null) {
            throw new RuntimeException("The class '" + clazz.getName() + "' is not instantiable: " + errorMessage);
        }
    }

    public static String checkForInstantiationError(Class<?> clazz) {
        if (!InstantiationUtil.isPublic(clazz)) {
            return "The class is not public.";
        }
        if (clazz.isArray()) {
            return "The class is an array. An array cannot be simply instantiated, as with a parameterless constructor.";
        }
        if (!InstantiationUtil.isProperClass(clazz)) {
            return "The class is no proper class, it is either abstract, an interface, or a primitive type.";
        }
        if (InstantiationUtil.isNonStaticInnerClass(clazz)) {
            return "The class is an inner class, but not statically accessible.";
        }
        if (!InstantiationUtil.hasPublicNullaryConstructor(clazz)) {
            return "The class has no (implicit) public nullary constructor, i.e. a constructor without arguments.";
        }
        return null;
    }

    public static <T> T readObjectFromConfig(Configuration config, String key, ClassLoader cl) throws IOException, ClassNotFoundException {
        byte[] bytes = config.getBytes(key, null);
        if (bytes == null) {
            return null;
        }
        return InstantiationUtil.deserializeObject(bytes, cl);
    }

    public static void writeObjectToConfig(Object o, Configuration config, String key) throws IOException {
        byte[] bytes = InstantiationUtil.serializeObject(o);
        config.setBytes(key, bytes);
    }

    public static <T> byte[] serializeToByteArray(TypeSerializer<T> serializer, T record) throws IOException {
        if (record == null) {
            throw new NullPointerException("Record to serialize to byte array must not be null.");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputViewStreamWrapper outputViewWrapper = new DataOutputViewStreamWrapper(bos);
        serializer.serialize(record, outputViewWrapper);
        return bos.toByteArray();
    }

    public static <T> T deserializeFromByteArray(TypeSerializer<T> serializer, byte[] buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException("Byte array to deserialize from must not be null.");
        }
        DataInputViewStreamWrapper inputViewWrapper = new DataInputViewStreamWrapper(new ByteArrayInputStream(buf));
        return serializer.deserialize(inputViewWrapper);
    }

    public static <T> T deserializeFromByteArray(TypeSerializer<T> serializer, T reuse, byte[] buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException("Byte array to deserialize from must not be null.");
        }
        DataInputViewStreamWrapper inputViewWrapper = new DataInputViewStreamWrapper(new ByteArrayInputStream(buf));
        return serializer.deserialize(reuse, inputViewWrapper);
    }

    /*
     * Loose catch block
     */
    public static <T> T deserializeObject(byte[] bytes, ClassLoader cl) throws IOException, ClassNotFoundException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Object object;
            try (ClassLoaderObjectInputStream oois = new ClassLoaderObjectInputStream(new ByteArrayInputStream(bytes), cl);){
                Thread.currentThread().setContextClassLoader(cl);
                object = oois.readObject();
            }
            return (T)object;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * Exception decompiling
     */
    public static byte[] serializeObject(Object o) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static <T extends Serializable> T clone(T obj) throws IOException, ClassNotFoundException {
        if (obj == null) {
            return null;
        }
        return InstantiationUtil.clone(obj, obj.getClass().getClassLoader());
    }

    public static <T extends Serializable> T clone(T obj, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        if (obj == null) {
            return null;
        }
        byte[] serializedObject = InstantiationUtil.serializeObject(obj);
        return (T)((Serializable)InstantiationUtil.deserializeObject(serializedObject, classLoader));
    }

    public static <T extends IOReadableWritable> T createCopyWritable(T original) throws IOException {
        if (original == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper(baos);){
            original.write(out);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (DataInputViewStreamWrapper in = new DataInputViewStreamWrapper(bais);){
            IOReadableWritable copy = (IOReadableWritable)InstantiationUtil.instantiate(original.getClass());
            copy.read(in);
            IOReadableWritable iOReadableWritable = copy;
            return (T)iOReadableWritable;
        }
    }

    private InstantiationUtil() {
        throw new RuntimeException();
    }

    public static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        private final ClassLoader classLoader;
        private static final HashMap<String, Class<?>> primitiveClasses = new HashMap(9);

        public ClassLoaderObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this.classLoader != null) {
                String name = desc.getName();
                try {
                    return Class.forName(name, false, this.classLoader);
                }
                catch (ClassNotFoundException ex) {
                    Class<?> cl = primitiveClasses.get(name);
                    if (cl != null) {
                        return cl;
                    }
                    throw ex;
                }
            }
            return super.resolveClass(desc);
        }

        static {
            primitiveClasses.put("boolean", Boolean.TYPE);
            primitiveClasses.put("byte", Byte.TYPE);
            primitiveClasses.put("char", Character.TYPE);
            primitiveClasses.put("short", Short.TYPE);
            primitiveClasses.put("int", Integer.TYPE);
            primitiveClasses.put("long", Long.TYPE);
            primitiveClasses.put("float", Float.TYPE);
            primitiveClasses.put("double", Double.TYPE);
            primitiveClasses.put("void", Void.TYPE);
        }
    }
}

