/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.api.common.io.ParseException;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.types.parser.StringParser;
import org.apache.flink.types.parser.StringValueParser;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class GenericCsvInputFormat<OT>
extends DelimitedInputFormat<OT> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(GenericCsvInputFormat.class);
    private static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private static final Class<?>[] EMPTY_TYPES = new Class[0];
    private static final boolean[] EMPTY_INCLUDED = new boolean[0];
    private static final byte[] DEFAULT_FIELD_DELIMITER = new byte[]{44};
    private static final byte BACKSLASH = 92;
    private transient FieldParser<?>[] fieldParsers;
    protected boolean lineDelimiterIsLinebreak = false;
    protected transient int commentCount;
    protected transient int invalidLineCount;
    private Class<?>[] fieldTypes = EMPTY_TYPES;
    protected boolean[] fieldIncluded = EMPTY_INCLUDED;
    private byte[] fieldDelim = DEFAULT_FIELD_DELIMITER;
    private boolean lenient;
    private boolean skipFirstLineAsHeader;
    private boolean quotedStringParsing = false;
    private byte quoteCharacter;
    protected byte[] commentPrefix = null;

    protected GenericCsvInputFormat() {
    }

    protected GenericCsvInputFormat(Path filePath) {
        super(filePath, null);
    }

    public int getNumberOfFieldsTotal() {
        return this.fieldIncluded.length;
    }

    public int getNumberOfNonNullFields() {
        return this.fieldTypes.length;
    }

    public byte[] getCommentPrefix() {
        return this.commentPrefix;
    }

    public void setCommentPrefix(byte[] commentPrefix) {
        this.commentPrefix = commentPrefix;
    }

    public void setCommentPrefix(char commentPrefix) {
        this.setCommentPrefix(String.valueOf(commentPrefix));
    }

    public void setCommentPrefix(String commentPrefix) {
        this.setCommentPrefix(commentPrefix, UTF_8_CHARSET);
    }

    public void setCommentPrefix(String commentPrefix, String charsetName) throws IllegalCharsetNameException, UnsupportedCharsetException {
        if (charsetName == null) {
            throw new IllegalArgumentException("Charset name must not be null");
        }
        if (commentPrefix != null) {
            Charset charset = Charset.forName(charsetName);
            this.setCommentPrefix(commentPrefix, charset);
        } else {
            this.commentPrefix = null;
        }
    }

    public void setCommentPrefix(String commentPrefix, Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("Charset must not be null");
        }
        this.commentPrefix = (byte[])(commentPrefix != null ? commentPrefix.getBytes(charset) : null);
    }

    public byte[] getFieldDelimiter() {
        return this.fieldDelim;
    }

    public void setFieldDelimiter(byte[] delimiter) {
        if (delimiter == null) {
            throw new IllegalArgumentException("Delimiter must not be null");
        }
        this.fieldDelim = delimiter;
    }

    public void setFieldDelimiter(char delimiter) {
        this.setFieldDelimiter(String.valueOf(delimiter));
    }

    public void setFieldDelimiter(String delimiter) {
        this.fieldDelim = delimiter.getBytes(UTF_8_CHARSET);
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean isSkippingFirstLineAsHeader() {
        return this.skipFirstLineAsHeader;
    }

    public void setSkipFirstLineAsHeader(boolean skipFirstLine) {
        this.skipFirstLineAsHeader = skipFirstLine;
    }

    public void enableQuotedStringParsing(char quoteCharacter) {
        this.quotedStringParsing = true;
        this.quoteCharacter = (byte)quoteCharacter;
    }

    protected FieldParser<?>[] getFieldParsers() {
        return this.fieldParsers;
    }

    protected Class<?>[] getGenericFieldTypes() {
        if (this.fieldIncluded.length == this.fieldTypes.length) {
            return this.fieldTypes;
        }
        Class[] types = new Class[this.fieldIncluded.length];
        int k = 0;
        for (int i = 0; i < this.fieldIncluded.length; ++i) {
            if (!this.fieldIncluded[i]) continue;
            types[i] = this.fieldTypes[k++];
        }
        return types;
    }

    protected void setFieldTypesGeneric(Class<?> ... fieldTypes) {
        if (fieldTypes == null) {
            throw new IllegalArgumentException("Field types must not be null.");
        }
        this.fieldIncluded = new boolean[fieldTypes.length];
        ArrayList types = new ArrayList();
        for (int i = 0; i < fieldTypes.length; ++i) {
            Class<?> type = fieldTypes[i];
            if (type == null) continue;
            if (FieldParser.getParserForType(type) == null) {
                throw new IllegalArgumentException("The type '" + type.getName() + "' is not supported for the CSV input format.");
            }
            types.add(type);
            this.fieldIncluded[i] = true;
        }
        this.fieldTypes = types.toArray(new Class[types.size()]);
    }

    protected void setFieldsGeneric(int[] sourceFieldIndices, Class<?>[] fieldTypes) {
        Preconditions.checkNotNull(sourceFieldIndices);
        Preconditions.checkNotNull(fieldTypes);
        Preconditions.checkArgument(sourceFieldIndices.length == fieldTypes.length, "Number of field indices and field types must match.");
        for (int i : sourceFieldIndices) {
            if (i >= 0) continue;
            throw new IllegalArgumentException("Field indices must not be smaller than zero.");
        }
        int largestFieldIndex = GenericCsvInputFormat.max(sourceFieldIndices);
        this.fieldIncluded = new boolean[largestFieldIndex + 1];
        ArrayList types = new ArrayList();
        for (int i = 0; i < fieldTypes.length; ++i) {
            Class<?> type = fieldTypes[i];
            if (type == null) continue;
            if (FieldParser.getParserForType(type) == null) {
                throw new IllegalArgumentException("The type '" + type.getName() + "' is not supported for the CSV input format.");
            }
            types.add(type);
            this.fieldIncluded[sourceFieldIndices[i]] = true;
        }
        this.fieldTypes = types.toArray(new Class[types.size()]);
    }

    protected void setFieldsGeneric(boolean[] includedMask, Class<?>[] fieldTypes) {
        Preconditions.checkNotNull(includedMask);
        Preconditions.checkNotNull(fieldTypes);
        ArrayList types = new ArrayList();
        int typeIndex = 0;
        for (int i = 0; i < includedMask.length; ++i) {
            Class<?> type;
            if (!includedMask[i]) continue;
            if (typeIndex > fieldTypes.length - 1) {
                throw new IllegalArgumentException("Missing type for included field " + i + ".");
            }
            if ((type = fieldTypes[typeIndex++]) == null) {
                throw new IllegalArgumentException("Type for included field " + i + " should not be null.");
            }
            if (FieldParser.getParserForType(type) == null) {
                throw new IllegalArgumentException("The type '" + type.getName() + "' is not supported for the CSV input format.");
            }
            types.add(type);
        }
        this.fieldTypes = types.toArray(new Class[types.size()]);
        this.fieldIncluded = includedMask;
    }

    @Override
    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        FieldParser[] parsers = new FieldParser[this.fieldTypes.length];
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            if (this.fieldTypes[i] == null) continue;
            Class<FieldParser<?>> parserType = FieldParser.getParserForType(this.fieldTypes[i]);
            if (parserType == null) {
                throw new RuntimeException("No parser available for type '" + this.fieldTypes[i].getName() + "'.");
            }
            FieldParser p = InstantiationUtil.instantiate(parserType, FieldParser.class);
            if (this.quotedStringParsing) {
                if (p instanceof StringParser) {
                    ((StringParser)p).enableQuotedStringParsing(this.quoteCharacter);
                } else if (p instanceof StringValueParser) {
                    ((StringValueParser)p).enableQuotedStringParsing(this.quoteCharacter);
                }
            }
            parsers[i] = p;
        }
        this.fieldParsers = parsers;
        if (this.skipFirstLineAsHeader && this.splitStart == 0L) {
            this.readLine();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.invalidLineCount > 0 && LOG.isWarnEnabled()) {
            LOG.warn("In file \"" + this.filePath + "\" (split start: " + this.splitStart + ") " + this.invalidLineCount + " invalid line(s) were skipped.");
        }
        if (this.commentCount > 0 && LOG.isInfoEnabled()) {
            LOG.info("In file \"" + this.filePath + "\" (split start: " + this.splitStart + ") " + this.commentCount + " comment line(s) were skipped.");
        }
        super.close();
    }

    protected boolean parseRecord(Object[] holders, byte[] bytes, int offset, int numBytes) throws ParseException {
        boolean[] fieldIncluded = this.fieldIncluded;
        int startPos = offset;
        int limit = offset + numBytes;
        int output = 0;
        for (int field = 0; field < fieldIncluded.length; ++field) {
            if (startPos >= limit) {
                if (this.lenient) {
                    return false;
                }
                throw new ParseException("Row too short: " + new String(bytes, offset, numBytes));
            }
            if (fieldIncluded[field]) {
                FieldParser<?> parser = this.fieldParsers[output];
                Object reuse = holders[output];
                startPos = parser.resetErrorStateAndParse(bytes, startPos, limit, this.fieldDelim, reuse);
                holders[output] = parser.getLastResult();
                if (startPos < 0) {
                    if (this.lenient) {
                        return false;
                    }
                    String lineAsString = new String(bytes, offset, numBytes);
                    throw new ParseException("Line could not be parsed: '" + lineAsString + "'\n" + "ParserError " + (Object)((Object)parser.getErrorState()) + " \n" + "Expect field types: " + this.fieldTypesToString() + " \n" + "in file: " + this.filePath);
                }
                ++output;
                continue;
            }
            if ((startPos = this.skipFields(bytes, startPos, limit, this.fieldDelim)) >= 0 || this.lenient) continue;
            String lineAsString = new String(bytes, offset, numBytes);
            throw new ParseException("Line could not be parsed: '" + lineAsString + "'\n" + "Expect field types: " + this.fieldTypesToString() + " \n" + "in file: " + this.filePath);
        }
        return true;
    }

    private String fieldTypesToString() {
        StringBuilder string = new StringBuilder();
        string.append(this.fieldTypes[0].toString());
        for (int i = 1; i < this.fieldTypes.length; ++i) {
            string.append(", ").append(this.fieldTypes[i]);
        }
        return string.toString();
    }

    protected int skipFields(byte[] bytes, int startPos, int limit, byte[] delim) {
        int i;
        int delimLimit = limit - delim.length + 1;
        if (this.quotedStringParsing && bytes[i] == this.quoteCharacter) {
            ++i;
            while (i < limit && (bytes[i] != this.quoteCharacter || bytes[i - 1] == 92)) {
                ++i;
            }
            if (++i == limit) {
                return limit;
            }
            if (i < delimLimit && FieldParser.delimiterNext(bytes, i, delim)) {
                return i + delim.length;
            }
            return -1;
        }
        for (i = startPos; i < delimLimit && !FieldParser.delimiterNext(bytes, i, delim); ++i) {
        }
        if (i >= delimLimit) {
            return limit;
        }
        return i + delim.length;
    }

    protected static void checkAndCoSort(int[] positions, Class<?>[] types) {
        int i;
        if (positions.length != types.length) {
            throw new IllegalArgumentException("The positions and types must be of the same length");
        }
        TreeMap map = new TreeMap();
        for (i = 0; i < positions.length; ++i) {
            if (positions[i] < 0) {
                throw new IllegalArgumentException("The field  (" + positions[i] + ") is invalid.");
            }
            if (types[i] == null) {
                throw new IllegalArgumentException("The type " + i + " is invalid (null)");
            }
            if (map.containsKey(positions[i])) {
                throw new IllegalArgumentException("The position " + positions[i] + " occurs multiple times.");
            }
            map.put(positions[i], types[i]);
        }
        i = 0;
        for (Map.Entry entry : map.entrySet()) {
            positions[i] = (Integer)entry.getKey();
            types[i] = (Class)entry.getValue();
            ++i;
        }
    }

    protected static void checkForMonotonousOrder(int[] positions, Class<?>[] types) {
        if (positions.length != types.length) {
            throw new IllegalArgumentException("The positions and types must be of the same length");
        }
        int lastPos = -1;
        for (int i = 0; i < positions.length; ++i) {
            if (positions[i] < 0) {
                throw new IllegalArgumentException("The field  (" + positions[i] + ") is invalid.");
            }
            if (types[i] == null) {
                throw new IllegalArgumentException("The type " + i + " is invalid (null)");
            }
            if (positions[i] <= lastPos) {
                throw new IllegalArgumentException("The positions must be strictly increasing (no permutations are supported).");
            }
            lastPos = positions[i];
        }
    }

    private static int max(int[] ints) {
        Preconditions.checkArgument(ints.length > 0);
        int max = ints[0];
        for (int i = 1; i < ints.length; ++i) {
            max = Math.max(max, ints[i]);
        }
        return max;
    }
}

