/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.state.StateBackend;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;

@PublicEvolving
public class ValueStateDescriptor<T>
extends StateDescriptor<ValueState<T>, T> {
    private static final long serialVersionUID = 1L;

    public ValueStateDescriptor(String name, Class<T> typeClass, T defaultValue) {
        super(name, typeClass, defaultValue);
    }

    public ValueStateDescriptor(String name, TypeInformation<T> typeInfo, T defaultValue) {
        super(name, typeInfo, defaultValue);
    }

    public ValueStateDescriptor(String name, TypeSerializer<T> typeSerializer, T defaultValue) {
        super(name, typeSerializer, defaultValue);
    }

    @Override
    public ValueState<T> bind(StateBackend stateBackend) throws Exception {
        return stateBackend.createValueState(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueStateDescriptor that = (ValueStateDescriptor)o;
        return this.serializer.equals(that.serializer) && this.name.equals(that.name);
    }

    @Override
    public int hashCode() {
        int result = this.serializer.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "ValueStateDescriptor{name=" + this.name + ", defaultValue=" + this.defaultValue + ", serializer=" + this.serializer + '}';
    }
}

