/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.sql.Date;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class SqlDateSerializer
extends TypeSerializerSingleton<Date> {
    private static final long serialVersionUID = 1L;
    public static final SqlDateSerializer INSTANCE = new SqlDateSerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public Date createInstance() {
        return new Date(0L);
    }

    @Override
    public Date copy(Date from) {
        if (from == null) {
            return null;
        }
        return new Date(from.getTime());
    }

    @Override
    public Date copy(Date from, Date reuse) {
        if (from == null) {
            return null;
        }
        reuse.setTime(from.getTime());
        return reuse;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void serialize(Date record, DataOutputView target) throws IOException {
        if (record == null) {
            target.writeLong(Long.MIN_VALUE);
        } else {
            target.writeLong(record.getTime());
        }
    }

    @Override
    public Date deserialize(DataInputView source) throws IOException {
        long v = source.readLong();
        if (v == Long.MIN_VALUE) {
            return null;
        }
        return new Date(v);
    }

    @Override
    public Date deserialize(Date reuse, DataInputView source) throws IOException {
        long v = source.readLong();
        if (v == Long.MIN_VALUE) {
            return null;
        }
        reuse.setTime(v);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeLong(source.readLong());
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof SqlDateSerializer;
    }
}

