/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.StringValue;

@Internal
public final class StringValueSerializer
extends TypeSerializerSingleton<StringValue> {
    private static final long serialVersionUID = 1L;
    private static final int HIGH_BIT = 128;
    public static final StringValueSerializer INSTANCE = new StringValueSerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public StringValue createInstance() {
        return new StringValue();
    }

    @Override
    public StringValue copy(StringValue from) {
        return this.copy(from, new StringValue());
    }

    @Override
    public StringValue copy(StringValue from, StringValue reuse) {
        reuse.setValue(from);
        return reuse;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(StringValue record, DataOutputView target) throws IOException {
        record.write(target);
    }

    @Override
    public StringValue deserialize(DataInputView source) throws IOException {
        return this.deserialize(new StringValue(), source);
    }

    @Override
    public StringValue deserialize(StringValue reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readUnsignedByte();
        target.writeByte(len);
        if (len >= 128) {
            int curr;
            int shift = 7;
            len &= 0x7F;
            while ((curr = source.readUnsignedByte()) >= 128) {
                target.writeByte(curr);
                len |= (curr & 0x7F) << shift;
                shift += 7;
            }
            target.writeByte(curr);
            len |= curr << shift;
        }
        for (int i = 0; i < len; ++i) {
            int c = source.readUnsignedByte();
            target.writeByte(c);
            while (c >= 128) {
                c = source.readUnsignedByte();
                target.writeByte(c);
            }
        }
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof StringValueSerializer;
    }
}

