/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.runtime.AvroSerializer;
import org.apache.flink.api.java.typeutils.runtime.PojoComparator;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.util.Preconditions;

@Public
public class PojoTypeInfo<T>
extends CompositeType<T> {
    private static final long serialVersionUID = 1L;
    private static final String REGEX_FIELD = "[\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*";
    private static final String REGEX_NESTED_FIELDS = "([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*)(\\.(.+))?";
    private static final String REGEX_NESTED_FIELDS_WILDCARD = "([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*)(\\.(.+))?|\\*|\\_";
    private static final Pattern PATTERN_NESTED_FIELDS = Pattern.compile("([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*)(\\.(.+))?");
    private static final Pattern PATTERN_NESTED_FIELDS_WILDCARD = Pattern.compile("([\\p{L}_\\$][\\p{L}\\p{Digit}_\\$]*)(\\.(.+))?|\\*|\\_");
    private final PojoField[] fields;
    private final int totalFields;

    @PublicEvolving
    public PojoTypeInfo(Class<T> typeClass, List<PojoField> fields) {
        super(typeClass);
        Preconditions.checkArgument(Modifier.isPublic(typeClass.getModifiers()), "POJO %s is not public", typeClass);
        this.fields = fields.toArray(new PojoField[fields.size()]);
        Arrays.sort(this.fields, new Comparator<PojoField>(){

            @Override
            public int compare(PojoField o1, PojoField o2) {
                return o1.getField().getName().compareTo(o2.getField().getName());
            }
        });
        int counterFields = 0;
        for (PojoField field : fields) {
            counterFields += field.getTypeInformation().getTotalFields();
        }
        this.totalFields = counterFields;
    }

    @Override
    @PublicEvolving
    public boolean isBasicType() {
        return false;
    }

    @Override
    @PublicEvolving
    public boolean isTupleType() {
        return false;
    }

    @Override
    @PublicEvolving
    public int getArity() {
        return this.fields.length;
    }

    @Override
    @PublicEvolving
    public int getTotalFields() {
        return this.totalFields;
    }

    @Override
    @PublicEvolving
    public boolean isSortKeyType() {
        return false;
    }

    @Override
    @PublicEvolving
    public void getFlatFields(String fieldExpression, int offset, List<CompositeType.FlatFieldDescriptor> result) {
        Matcher matcher = PATTERN_NESTED_FIELDS_WILDCARD.matcher(fieldExpression);
        if (!matcher.matches()) {
            throw new CompositeType.InvalidFieldReferenceException("Invalid POJO field reference \"" + fieldExpression + "\".");
        }
        String field = matcher.group(0);
        if (field.equals("*") || field.equals("_")) {
            int keyPosition = 0;
            for (PojoField pField : this.fields) {
                if (pField.getTypeInformation() instanceof CompositeType) {
                    CompositeType cType = (CompositeType)pField.getTypeInformation();
                    cType.getFlatFields(String.valueOf("*"), offset + keyPosition, result);
                    keyPosition += cType.getTotalFields() - 1;
                } else {
                    result.add(new NamedFlatFieldDescriptor(pField.getField().getName(), offset + keyPosition, pField.getTypeInformation()));
                }
                ++keyPosition;
            }
            return;
        }
        field = matcher.group(1);
        int fieldPos = -1;
        TypeInformation<?> fieldType = null;
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].getField().getName().equals(field)) continue;
            fieldPos = i;
            fieldType = this.fields[i].getTypeInformation();
            break;
        }
        if (fieldPos == -1) {
            throw new CompositeType.InvalidFieldReferenceException("Unable to find field \"" + field + "\" in type " + this + ".");
        }
        String tail = matcher.group(3);
        if (tail == null) {
            if (fieldType instanceof CompositeType) {
                for (int i = 0; i < fieldPos; ++i) {
                    offset += this.getTypeAt(i).getTotalFields();
                }
                ((CompositeType)fieldType).getFlatFields("*", offset, result);
            } else {
                int flatFieldPos = offset;
                for (int i = 0; i < fieldPos; ++i) {
                    flatFieldPos += this.getTypeAt(i).getTotalFields();
                }
                result.add(new CompositeType.FlatFieldDescriptor(flatFieldPos, fieldType));
            }
        } else if (fieldType instanceof CompositeType) {
            for (int i = 0; i < fieldPos; ++i) {
                offset += this.getTypeAt(i).getTotalFields();
            }
            ((CompositeType)fieldType).getFlatFields(tail, offset, result);
        } else {
            throw new CompositeType.InvalidFieldReferenceException("Nested field expression \"" + tail + "\" not possible on atomic type " + fieldType + ".");
        }
    }

    @Override
    @PublicEvolving
    public <X> TypeInformation<X> getTypeAt(String fieldExpression) {
        Matcher matcher = PATTERN_NESTED_FIELDS.matcher(fieldExpression);
        if (!matcher.matches()) {
            if (fieldExpression.startsWith("*") || fieldExpression.startsWith("_")) {
                throw new CompositeType.InvalidFieldReferenceException("Wildcard expressions are not allowed here.");
            }
            throw new CompositeType.InvalidFieldReferenceException("Invalid format of POJO field expression \"" + fieldExpression + "\".");
        }
        String field = matcher.group(1);
        int fieldPos = -1;
        TypeInformation<?> fieldType = null;
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].getField().getName().equals(field)) continue;
            fieldPos = i;
            fieldType = this.fields[i].getTypeInformation();
            break;
        }
        if (fieldPos == -1) {
            throw new CompositeType.InvalidFieldReferenceException("Unable to find field \"" + field + "\" in type " + this + ".");
        }
        String tail = matcher.group(3);
        if (tail == null) {
            return fieldType;
        }
        if (fieldType instanceof CompositeType) {
            return ((CompositeType)fieldType).getTypeAt(tail);
        }
        throw new CompositeType.InvalidFieldReferenceException("Nested field expression \"" + tail + "\" not possible on atomic type " + fieldType + ".");
    }

    @Override
    @PublicEvolving
    public <X> TypeInformation<X> getTypeAt(int pos) {
        if (pos < 0 || pos >= this.fields.length) {
            throw new IndexOutOfBoundsException();
        }
        TypeInformation<?> typed = this.fields[pos].getTypeInformation();
        return typed;
    }

    @Override
    protected CompositeType.TypeComparatorBuilder<T> createTypeComparatorBuilder() {
        return new PojoTypeComparatorBuilder();
    }

    @PublicEvolving
    public PojoField getPojoFieldAt(int pos) {
        if (pos < 0 || pos >= this.fields.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.fields[pos];
    }

    @Override
    @PublicEvolving
    public String[] getFieldNames() {
        String[] result = new String[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            result[i] = this.fields[i].getField().getName();
        }
        return result;
    }

    @Override
    @PublicEvolving
    public int getFieldIndex(String fieldName) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].getField().getName().equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    @PublicEvolving
    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        if (config.isForceKryoEnabled()) {
            return new KryoSerializer(this.getTypeClass(), config);
        }
        if (config.isForceAvroEnabled()) {
            return new AvroSerializer(this.getTypeClass());
        }
        TypeSerializer[] fieldSerializers = new TypeSerializer[this.fields.length];
        Field[] reflectiveFields = new Field[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            fieldSerializers[i] = this.fields[i].getTypeInformation().createSerializer(config);
            reflectiveFields[i] = this.fields[i].getField();
        }
        return new PojoSerializer(this.getTypeClass(), fieldSerializers, reflectiveFields, config);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PojoTypeInfo) {
            PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)obj;
            return pojoTypeInfo.canEqual(this) && super.equals(pojoTypeInfo) && Arrays.equals(this.fields, pojoTypeInfo.fields) && this.totalFields == pojoTypeInfo.totalFields;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * (31 * Arrays.hashCode(this.fields) + this.totalFields) + super.hashCode();
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof PojoTypeInfo;
    }

    @Override
    public String toString() {
        ArrayList<String> fieldStrings = new ArrayList<String>();
        for (PojoField field : this.fields) {
            fieldStrings.add(field.getField().getName() + ": " + field.getTypeInformation().toString());
        }
        return "PojoType<" + this.getTypeClass().getName() + ", fields = [" + StringUtils.join(fieldStrings, (String)", ") + "]" + ">";
    }

    public static class NamedFlatFieldDescriptor
    extends CompositeType.FlatFieldDescriptor {
        private String fieldName;

        public NamedFlatFieldDescriptor(String name, int keyPosition, TypeInformation<?> type) {
            super(keyPosition, type);
            this.fieldName = name;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public String toString() {
            return "NamedFlatFieldDescriptor [name=" + this.fieldName + " position=" + this.getPosition() + " typeInfo=" + this.getType() + "]";
        }
    }

    private class PojoTypeComparatorBuilder
    implements CompositeType.TypeComparatorBuilder<T> {
        private ArrayList<TypeComparator> fieldComparators = new ArrayList();
        private ArrayList<Field> keyFields = new ArrayList();

        @Override
        public void initializeTypeComparatorBuilder(int size) {
            this.fieldComparators.ensureCapacity(size);
            this.keyFields.ensureCapacity(size);
        }

        @Override
        public void addComparatorField(int fieldId, TypeComparator<?> comparator) {
            this.fieldComparators.add(comparator);
            this.keyFields.add(PojoTypeInfo.this.fields[fieldId].getField());
        }

        @Override
        public TypeComparator<T> createTypeComparator(ExecutionConfig config) {
            Preconditions.checkState(this.keyFields.size() > 0, "No keys were defined for the PojoTypeComparatorBuilder.");
            Preconditions.checkState(this.fieldComparators.size() > 0, "No type comparators were defined for the PojoTypeComparatorBuilder.");
            Preconditions.checkState(this.keyFields.size() == this.fieldComparators.size(), "Number of key fields and field comparators is not equal.");
            return new PojoComparator(this.keyFields.toArray(new Field[this.keyFields.size()]), this.fieldComparators.toArray(new TypeComparator[this.fieldComparators.size()]), PojoTypeInfo.this.createSerializer(config), PojoTypeInfo.this.getTypeClass());
        }
    }
}

