/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import java.io.IOException;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.DataInputDecoder;
import org.apache.flink.api.java.typeutils.runtime.DataOutputEncoder;
import org.apache.flink.api.java.typeutils.runtime.KryoUtils;
import org.apache.flink.api.java.typeutils.runtime.kryo.Serializers;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public final class AvroSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type;
    private final Class<? extends T> typeToInstantiate;
    private transient ReflectDatumWriter<T> writer;
    private transient ReflectDatumReader<T> reader;
    private transient DataOutputEncoder encoder;
    private transient DataInputDecoder decoder;
    private transient Kryo kryo;
    private transient T deepCopyInstance;

    public AvroSerializer(Class<T> type) {
        this(type, type);
    }

    public AvroSerializer(Class<T> type, Class<? extends T> typeToInstantiate) {
        this.type = Preconditions.checkNotNull(type);
        this.typeToInstantiate = Preconditions.checkNotNull(typeToInstantiate);
        InstantiationUtil.checkForInstantiation(typeToInstantiate);
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public AvroSerializer<T> duplicate() {
        return new AvroSerializer<T>(this.type, this.typeToInstantiate);
    }

    @Override
    public T createInstance() {
        return InstantiationUtil.instantiate(this.typeToInstantiate);
    }

    @Override
    public T copy(T from) {
        this.checkKryoInitialized();
        return KryoUtils.copy(from, this.kryo, this);
    }

    @Override
    public T copy(T from, T reuse) {
        this.checkKryoInitialized();
        return KryoUtils.copy(from, reuse, this.kryo, this);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(T value, DataOutputView target) throws IOException {
        this.checkAvroInitialized();
        this.encoder.setOut(target);
        this.writer.write(value, (Encoder)this.encoder);
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        this.checkAvroInitialized();
        this.decoder.setIn(source);
        return (T)this.reader.read(null, (Decoder)this.decoder);
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        this.checkAvroInitialized();
        this.decoder.setIn(source);
        return (T)this.reader.read(reuse, (Decoder)this.decoder);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.checkAvroInitialized();
        if (this.deepCopyInstance == null) {
            this.deepCopyInstance = InstantiationUtil.instantiate(this.type, Object.class);
        }
        this.decoder.setIn(source);
        this.encoder.setOut(target);
        Object tmp = this.reader.read(this.deepCopyInstance, (Decoder)this.decoder);
        this.writer.write(tmp, (Encoder)this.encoder);
    }

    private void checkAvroInitialized() {
        if (this.reader == null) {
            this.reader = new ReflectDatumReader(this.type);
            this.writer = new ReflectDatumWriter(this.type);
            this.encoder = new DataOutputEncoder();
            this.decoder = new DataInputDecoder();
        }
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            Kryo.DefaultInstantiatorStrategy instantiatorStrategy = new Kryo.DefaultInstantiatorStrategy();
            instantiatorStrategy.setFallbackInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
            this.kryo.setInstantiatorStrategy((InstantiatorStrategy)instantiatorStrategy);
            this.kryo.register(GenericData.Array.class, (Serializer)new Serializers.SpecificInstanceCollectionSerializerForArrayList());
            this.kryo.register(Utf8.class);
            this.kryo.register(GenericData.EnumSymbol.class);
            this.kryo.register(GenericData.Fixed.class);
            this.kryo.register(GenericData.StringType.class);
            this.kryo.setAsmEnabled(true);
            this.kryo.register(this.type);
        }
    }

    @Override
    public int hashCode() {
        return 31 * this.type.hashCode() + this.typeToInstantiate.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AvroSerializer) {
            AvroSerializer avroSerializer = (AvroSerializer)obj;
            return avroSerializer.canEqual(this) && this.type == avroSerializer.type && this.typeToInstantiate == avroSerializer.typeToInstantiate;
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof AvroSerializer;
    }
}

