/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.InstantiationUtil;

@Internal
public class KryoUtils {
    public static <T> T copy(T from, Kryo kryo, TypeSerializer<T> serializer) {
        try {
            return (T)kryo.copy(from);
        }
        catch (KryoException ke) {
            try {
                byte[] byteArray = InstantiationUtil.serializeToByteArray(serializer, from);
                return InstantiationUtil.deserializeFromByteArray(serializer, byteArray);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not copy object by serializing/deserializing it.", ioe);
            }
        }
    }

    public static <T> T copy(T from, T reuse, Kryo kryo, TypeSerializer<T> serializer) {
        try {
            return (T)kryo.copy(from);
        }
        catch (KryoException ke) {
            try {
                byte[] byteArray = InstantiationUtil.serializeToByteArray(serializer, from);
                return InstantiationUtil.deserializeFromByteArray(serializer, reuse, byteArray);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not copy object by serializing/deserializing it.", ioe);
            }
        }
    }
}

