/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.factories.ReflectionSerializerFactory;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.avro.generic.GenericData;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.api.java.typeutils.runtime.NoFetchingInput;
import org.apache.flink.api.java.typeutils.runtime.kryo.Serializers;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 3L;
    private static final Logger LOG = LoggerFactory.getLogger(KryoSerializer.class);
    private final LinkedHashMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> registeredTypesWithSerializers;
    private final LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> registeredTypesWithSerializerClasses;
    private final LinkedHashMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> defaultSerializers;
    private final LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> defaultSerializerClasses;
    private final LinkedHashSet<Class<?>> registeredTypes;
    private final Class<T> type;
    private transient Kryo kryo;
    private transient T copyInstance;
    private transient DataOutputView previousOut;
    private transient DataInputView previousIn;
    private transient Input input;
    private transient Output output;

    public KryoSerializer(Class<T> type, ExecutionConfig executionConfig) {
        this.type = Preconditions.checkNotNull(type);
        this.defaultSerializers = executionConfig.getDefaultKryoSerializers();
        this.defaultSerializerClasses = executionConfig.getDefaultKryoSerializerClasses();
        this.registeredTypesWithSerializers = executionConfig.getRegisteredTypesWithKryoSerializers();
        this.registeredTypesWithSerializerClasses = executionConfig.getRegisteredTypesWithKryoSerializerClasses();
        this.registeredTypes = executionConfig.getRegisteredKryoTypes();
    }

    protected KryoSerializer(KryoSerializer<T> toCopy) {
        this.registeredTypesWithSerializers = toCopy.registeredTypesWithSerializers;
        this.registeredTypesWithSerializerClasses = toCopy.registeredTypesWithSerializerClasses;
        this.defaultSerializers = toCopy.defaultSerializers;
        this.defaultSerializerClasses = toCopy.defaultSerializerClasses;
        this.registeredTypes = toCopy.registeredTypes;
        this.type = toCopy.type;
        if (this.type == null) {
            throw new NullPointerException("Type class cannot be null.");
        }
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public KryoSerializer<T> duplicate() {
        return new KryoSerializer<T>(this);
    }

    @Override
    public T createInstance() {
        if (Modifier.isAbstract(this.type.getModifiers()) || Modifier.isInterface(this.type.getModifiers())) {
            return null;
        }
        this.checkKryoInitialized();
        try {
            return (T)this.kryo.newInstance(this.type);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public T copy(T from) {
        if (from == null) {
            return null;
        }
        this.checkKryoInitialized();
        try {
            return (T)this.kryo.copy(from);
        }
        catch (KryoException ke) {
            ByteArrayOutputStream baout = new ByteArrayOutputStream();
            Output output = new Output((OutputStream)baout);
            this.kryo.writeObject(output, from);
            output.close();
            ByteArrayInputStream bain = new ByteArrayInputStream(baout.toByteArray());
            Input input = new Input((InputStream)bain);
            return (T)this.kryo.readObject(input, from.getClass());
        }
    }

    @Override
    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        this.checkKryoInitialized();
        if (target != this.previousOut) {
            DataOutputViewStream outputStream = new DataOutputViewStream(target);
            this.output = new Output((OutputStream)outputStream);
            this.previousOut = target;
        }
        if (this.output.position() != 0) {
            throw new IllegalStateException("The Kryo Output still contains data from a previous serialize call. It has to be flushed or cleared at the end of the serialize call.");
        }
        try {
            this.kryo.writeClassAndObject(this.output, record);
            this.output.flush();
        }
        catch (KryoException ke) {
            this.output.clear();
            Throwable cause = ke.getCause();
            if (cause instanceof EOFException) {
                throw (EOFException)cause;
            }
            throw ke;
        }
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        this.checkKryoInitialized();
        if (source != this.previousIn) {
            DataInputViewStream inputStream = new DataInputViewStream(source);
            this.input = new NoFetchingInput(inputStream);
            this.previousIn = source;
        }
        try {
            return (T)this.kryo.readClassAndObject(this.input);
        }
        catch (KryoException ke) {
            Throwable cause = ke.getCause();
            if (cause instanceof EOFException) {
                throw (EOFException)cause;
            }
            throw ke;
        }
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.checkKryoInitialized();
        if (this.copyInstance == null) {
            this.copyInstance = this.createInstance();
        }
        T tmp = this.deserialize(this.copyInstance, source);
        this.serialize(tmp, target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.registeredTypes, this.registeredTypesWithSerializerClasses, this.defaultSerializerClasses);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof KryoSerializer) {
            KryoSerializer other = (KryoSerializer)obj;
            return other.canEqual(this) && this.type == other.type && this.registeredTypes.equals(other.registeredTypes) && this.registeredTypesWithSerializerClasses.equals(other.registeredTypesWithSerializerClasses) && this.defaultSerializerClasses.equals(other.defaultSerializerClasses);
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof KryoSerializer;
    }

    private Kryo getKryoInstance() {
        try {
            Class<?> chillInstantiatorClazz = Class.forName("com.twitter.chill.ScalaKryoInstantiator");
            Object chillInstantiator = chillInstantiatorClazz.newInstance();
            Method m = chillInstantiatorClazz.getMethod("newKryo", new Class[0]);
            return (Kryo)m.invoke(chillInstantiator, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.warn("Falling back to default Kryo serializer because Chill serializer couldn't be found.", (Throwable)e);
            Kryo.DefaultInstantiatorStrategy initStrategy = new Kryo.DefaultInstantiatorStrategy();
            initStrategy.setFallbackInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
            Kryo kryo = new Kryo();
            kryo.setInstantiatorStrategy((InstantiatorStrategy)initStrategy);
            return kryo;
        }
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = this.getKryoInstance();
            this.kryo.setReferences(true);
            this.kryo.addDefaultSerializer(Throwable.class, (Serializer)new JavaSerializer());
            for (Map.Entry<Class<?>, ExecutionConfig.SerializableSerializer<?>> entry : this.defaultSerializers.entrySet()) {
                this.kryo.addDefaultSerializer(entry.getKey(), entry.getValue().getSerializer());
            }
            for (Map.Entry<Class<?>, Serializable> entry : this.defaultSerializerClasses.entrySet()) {
                this.kryo.addDefaultSerializer(entry.getKey(), (Class)entry.getValue());
            }
            this.kryo.register(this.type);
            for (Class clazz : this.registeredTypes) {
                this.kryo.register(clazz);
            }
            for (Map.Entry<Class<Object>, Serializable> entry : this.registeredTypesWithSerializerClasses.entrySet()) {
                Class<Object> typeClass = entry.getKey();
                Class serializerClass = (Class)entry.getValue();
                Serializer serializer = ReflectionSerializerFactory.makeSerializer((Kryo)this.kryo, (Class)serializerClass, typeClass);
                this.kryo.register(typeClass, serializer);
            }
            for (Map.Entry<Class<Object>, Serializable> entry : this.registeredTypesWithSerializers.entrySet()) {
                this.kryo.register(entry.getKey(), ((ExecutionConfig.SerializableSerializer)entry.getValue()).getSerializer());
            }
            this.kryo.register(GenericData.Array.class, (Serializer)new Serializers.SpecificInstanceCollectionSerializerForArrayList());
            this.kryo.setRegistrationRequired(false);
            this.kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        }
    }

    public Kryo getKryo() {
        this.checkKryoInitialized();
        return this.kryo;
    }
}

