/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class DelegatingConfiguration
extends Configuration {
    private static final long serialVersionUID = 1L;
    private final Configuration backingConfig;
    private String prefix;

    public DelegatingConfiguration() {
        this.backingConfig = new Configuration();
        this.prefix = "";
    }

    public DelegatingConfiguration(Configuration backingConfig, String prefix) {
        this.backingConfig = backingConfig;
        this.prefix = prefix;
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.backingConfig.getString(this.prefix + key, defaultValue);
    }

    @Override
    public void setString(String key, String value) {
        this.backingConfig.setString(this.prefix + key, value);
    }

    @Override
    public <T> Class<T> getClass(String key, Class<? extends T> defaultValue, ClassLoader classLoader) throws ClassNotFoundException {
        return this.backingConfig.getClass(this.prefix + key, defaultValue, classLoader);
    }

    @Override
    public void setClass(String key, Class<?> klazz) {
        this.backingConfig.setClass(this.prefix + key, klazz);
    }

    @Override
    public int getInteger(String key, int defaultValue) {
        return this.backingConfig.getInteger(this.prefix + key, defaultValue);
    }

    @Override
    public void setInteger(String key, int value) {
        this.backingConfig.setInteger(this.prefix + key, value);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.backingConfig.getLong(this.prefix + key, defaultValue);
    }

    @Override
    public void setLong(String key, long value) {
        this.backingConfig.setLong(this.prefix + key, value);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.backingConfig.getBoolean(this.prefix + key, defaultValue);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.backingConfig.setBoolean(this.prefix + key, value);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return this.backingConfig.getFloat(this.prefix + key, defaultValue);
    }

    @Override
    public void setFloat(String key, float value) {
        this.backingConfig.setFloat(this.prefix + key, value);
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.backingConfig.getDouble(this.prefix + key, defaultValue);
    }

    @Override
    public void setDouble(String key, double value) {
        this.backingConfig.setDouble(this.prefix + key, value);
    }

    @Override
    public byte[] getBytes(String key, byte[] defaultValue) {
        return this.backingConfig.getBytes(this.prefix + key, defaultValue);
    }

    @Override
    public void setBytes(String key, byte[] bytes) {
        this.backingConfig.setBytes(this.prefix + key, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAllToProperties(Properties props) {
        HashMap<String, Object> hashMap = this.backingConfig.confData;
        synchronized (hashMap) {
            for (Map.Entry<String, Object> entry : this.backingConfig.confData.entrySet()) {
                if (!entry.getKey().startsWith(this.prefix)) continue;
                String keyWithoutPrefix = entry.getKey().substring(this.prefix.length(), entry.getKey().length());
                props.put(keyWithoutPrefix, entry.getValue());
            }
        }
    }

    @Override
    public void addAll(Configuration other) {
        this.addAll(other, "");
    }

    @Override
    public void addAll(Configuration other, String prefix) {
        this.backingConfig.addAll(other, this.prefix + prefix);
    }

    @Override
    public String toString() {
        return this.backingConfig.toString();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        int prefixLen = this.prefix == null ? 0 : this.prefix.length();
        for (String key : this.backingConfig.keySet()) {
            if (!key.startsWith(this.prefix)) continue;
            set.add(key.substring(prefixLen));
        }
        return set;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        this.prefix = in.readUTF();
        this.backingConfig.read(in);
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        out.writeUTF(this.prefix);
        this.backingConfig.write(out);
    }

    @Override
    public int hashCode() {
        return this.prefix.hashCode() ^ this.backingConfig.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DelegatingConfiguration) {
            DelegatingConfiguration other = (DelegatingConfiguration)obj;
            return this.prefix.equals(other.prefix) && this.backingConfig.equals(other.backingConfig);
        }
        return false;
    }
}

