/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class GlobalConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalConfiguration.class);
    public static final String FLINK_CONF_FILENAME = "flink-conf.yaml";

    private GlobalConfiguration() {
    }

    public static Configuration loadConfiguration() {
        String configDir = System.getenv("FLINK_CONF_DIR");
        if (configDir == null) {
            return new Configuration();
        }
        return GlobalConfiguration.loadConfiguration(configDir);
    }

    public static Configuration loadConfiguration(String configDir) {
        if (configDir == null) {
            throw new IllegalArgumentException("Given configuration directory is null, cannot load configuration");
        }
        File confDirFile = new File(configDir);
        if (!confDirFile.exists()) {
            throw new IllegalConfigurationException("The given configuration directory name '" + configDir + "' (" + confDirFile.getAbsolutePath() + ") does not describe an existing directory.");
        }
        File yamlConfigFile = new File(confDirFile, FLINK_CONF_FILENAME);
        if (!yamlConfigFile.exists()) {
            throw new IllegalConfigurationException("The Flink config file '" + yamlConfigFile + "' (" + confDirFile.getAbsolutePath() + ") does not exist.");
        }
        return GlobalConfiguration.loadYAMLResource(yamlConfigFile);
    }

    private static Configuration loadYAMLResource(File file) {
        Configuration config = new Configuration();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] comments = line.split("#", 2);
                String conf = comments[0];
                if (conf.length() <= 0) continue;
                String[] kv = conf.split(": ", 2);
                if (kv.length == 1) {
                    LOG.warn("Error while trying to split key and value in configuration file " + file + ": " + line);
                    continue;
                }
                String key = kv[0].trim();
                String value = kv[1].trim();
                if (key.length() == 0 || value.length() == 0) {
                    LOG.warn("Error after splitting key and value in configuration file " + file + ": " + line);
                    continue;
                }
                LOG.debug("Loading configuration property: {}, {}", (Object)key, (Object)value);
                config.setString(key, value);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error parsing YAML configuration.", e);
        }
        return config;
    }
}

