/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalBlockLocation;
import org.apache.flink.core.fs.local.LocalDataInputStream;
import org.apache.flink.core.fs.local.LocalDataOutputStream;
import org.apache.flink.core.fs.local.LocalFileStatus;
import org.apache.flink.util.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class LocalFileSystem
extends FileSystem {
    private Path workingDir = null;
    private final URI name = OperatingSystem.isWindows() ? URI.create("file:/") : URI.create("file:///");
    private final String hostName;
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileSystem.class);

    public LocalFileSystem() {
        this.workingDir = new Path(System.getProperty("user.dir")).makeQualified(this);
        String tmp = "unknownHost";
        try {
            tmp = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("Could not resolve local host", (Throwable)e);
        }
        this.hostName = tmp;
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        BlockLocation[] blockLocations = new BlockLocation[]{new LocalBlockLocation(this.hostName, file.getLen())};
        return blockLocations;
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        File path = this.pathToFile(f);
        if (path.exists()) {
            return new LocalFileStatus(this.pathToFile(f), this);
        }
        throw new FileNotFoundException("File " + f + " does not exist or the user running " + "Flink ('" + System.getProperty("user.name") + "') has insufficient permissions to access it.");
    }

    @Override
    public URI getUri() {
        return this.name;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public Path getHomeDirectory() {
        return new Path(System.getProperty("user.home"));
    }

    @Override
    public void initialize(URI name) throws IOException {
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.open(f);
    }

    @Override
    public FSDataInputStream open(Path f) throws IOException {
        File file = this.pathToFile(f);
        return new LocalDataInputStream(file);
    }

    private File pathToFile(Path path) {
        if (!path.isAbsolute()) {
            path = new Path(this.getWorkingDirectory(), path);
        }
        return new File(path.toUri().getPath());
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        File localf = this.pathToFile(f);
        if (!localf.exists()) {
            return null;
        }
        if (localf.isFile()) {
            return new FileStatus[]{new LocalFileStatus(localf, this)};
        }
        String[] names = localf.list();
        if (names == null) {
            return null;
        }
        FileStatus[] results = new FileStatus[names.length];
        for (int i = 0; i < names.length; ++i) {
            results[i] = this.getFileStatus(new Path(f, names[i]));
        }
        return results;
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        File file = this.pathToFile(f);
        if (file.isFile()) {
            return file.delete();
        }
        if (!recursive && file.isDirectory() && file.listFiles().length != 0) {
            throw new IOException("Directory " + file.toString() + " is not empty");
        }
        return this.delete(file);
    }

    private boolean delete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = f.listFiles()) {
                boolean del = this.delete(file);
                if (del) continue;
                return false;
            }
        } else {
            return f.delete();
        }
        return f.delete();
    }

    @Override
    public boolean mkdirs(Path f) throws IOException {
        File p2f = this.pathToFile(f);
        if (p2f.isDirectory()) {
            return true;
        }
        Path parent = f.getParent();
        return !(parent != null && !this.mkdirs(parent) || !p2f.mkdir() && !p2f.isDirectory());
    }

    @Override
    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        if (this.exists(f) && !overwrite) {
            throw new IOException("File already exists:" + f);
        }
        Path parent = f.getParent();
        if (parent != null && !this.mkdirs(parent)) {
            throw new IOException("Mkdirs failed to create " + parent.toString());
        }
        File file = this.pathToFile(f);
        return new LocalDataOutputStream(file);
    }

    @Override
    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.create(f, overwrite, 0, (short)0, 0L);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        File srcFile = this.pathToFile(src);
        File dstFile = this.pathToFile(dst);
        return srcFile.renameTo(dstFile);
    }

    @Override
    public boolean isDistributedFS() {
        return false;
    }
}

