/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;

@Internal
public final class HybridMemorySegment
extends MemorySegment {
    private final ByteBuffer offHeapBuffer;
    private static final Field ADDRESS_FIELD;
    public static final HybridMemorySegmentFactory FACTORY;

    HybridMemorySegment(ByteBuffer buffer) {
        this(buffer, null);
    }

    HybridMemorySegment(ByteBuffer buffer, Object owner) {
        super(HybridMemorySegment.checkBufferAndGetAddress(buffer), buffer.capacity(), owner);
        this.offHeapBuffer = buffer;
    }

    HybridMemorySegment(byte[] buffer) {
        this(buffer, null);
    }

    HybridMemorySegment(byte[] buffer, Object owner) {
        super(buffer, owner);
        this.offHeapBuffer = null;
    }

    public byte[] getArray() {
        if (this.heapMemory != null) {
            return this.heapMemory;
        }
        throw new IllegalStateException("Memory segment does not represent heap memory");
    }

    public ByteBuffer getOffHeapBuffer() {
        if (this.offHeapBuffer != null) {
            return this.offHeapBuffer;
        }
        throw new IllegalStateException("Memory segment does not represent off heap memory");
    }

    @Override
    public ByteBuffer wrap(int offset, int length) {
        if (this.address <= this.addressLimit) {
            if (this.heapMemory != null) {
                return ByteBuffer.wrap(this.heapMemory, offset, length);
            }
            try {
                ByteBuffer wrapper = this.offHeapBuffer.duplicate();
                wrapper.limit(offset + length);
                wrapper.position(offset);
                return wrapper;
            }
            catch (IllegalArgumentException e) {
                throw new IndexOutOfBoundsException();
            }
        }
        throw new IllegalStateException("segment has been freed");
    }

    @Override
    public byte get(int index) {
        long pos = this.address + (long)index;
        if (index >= 0 && pos < this.addressLimit) {
            return UNSAFE.getByte(this.heapMemory, pos);
        }
        if (this.address > this.addressLimit) {
            throw new IllegalStateException("segment has been freed");
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void put(int index, byte b) {
        long pos = this.address + (long)index;
        if (index < 0 || pos >= this.addressLimit) {
            if (this.address > this.addressLimit) {
                throw new IllegalStateException("segment has been freed");
            }
            throw new IndexOutOfBoundsException();
        }
        UNSAFE.putByte(this.heapMemory, pos, b);
    }

    @Override
    public void get(int index, byte[] dst) {
        this.get(index, dst, 0, dst.length);
    }

    @Override
    public void put(int index, byte[] src) {
        this.put(index, src, 0, src.length);
    }

    @Override
    public void get(int index, byte[] dst, int offset, int length) {
        if ((offset | length | offset + length | dst.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        long pos = this.address + (long)index;
        if (index < 0 || pos > this.addressLimit - (long)length) {
            if (this.address > this.addressLimit) {
                throw new IllegalStateException("segment has been freed");
            }
            throw new IndexOutOfBoundsException();
        }
        long arrayAddress = BYTE_ARRAY_BASE_OFFSET + (long)offset;
        UNSAFE.copyMemory(this.heapMemory, pos, dst, arrayAddress, length);
    }

    @Override
    public void put(int index, byte[] src, int offset, int length) {
        if ((offset | length | offset + length | src.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        long pos = this.address + (long)index;
        if (index < 0 || pos > this.addressLimit - (long)length) {
            if (this.address > this.addressLimit) {
                throw new IllegalStateException("segment has been freed");
            }
            throw new IndexOutOfBoundsException();
        }
        long arrayAddress = BYTE_ARRAY_BASE_OFFSET + (long)offset;
        UNSAFE.copyMemory(src, arrayAddress, this.heapMemory, pos, length);
    }

    @Override
    public boolean getBoolean(int index) {
        return this.get(index) != 0;
    }

    @Override
    public void putBoolean(int index, boolean value) {
        this.put(index, (byte)(value ? 1 : 0));
    }

    @Override
    public final void get(DataOutput out, int offset, int length) throws IOException {
        if (this.address <= this.addressLimit) {
            if (this.heapMemory != null) {
                out.write(this.heapMemory, offset, length);
            } else {
                while (length >= 8) {
                    out.writeLong(this.getLongBigEndian(offset));
                    offset += 8;
                    length -= 8;
                }
                while (length > 0) {
                    out.writeByte(this.get(offset));
                    ++offset;
                    --length;
                }
            }
        } else {
            throw new IllegalStateException("segment has been freed");
        }
    }

    @Override
    public final void put(DataInput in, int offset, int length) throws IOException {
        if (this.address <= this.addressLimit) {
            if (this.heapMemory != null) {
                in.readFully(this.heapMemory, offset, length);
            } else {
                while (length >= 8) {
                    this.putLongBigEndian(offset, in.readLong());
                    offset += 8;
                    length -= 8;
                }
                while (length > 0) {
                    this.put(offset, in.readByte());
                    ++offset;
                    --length;
                }
            }
        } else {
            throw new IllegalStateException("segment has been freed");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void get(int offset, ByteBuffer target, int numBytes) {
        if ((offset | numBytes | offset + numBytes) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int targetOffset = target.position();
        int remaining = target.remaining();
        if (remaining < numBytes) {
            throw new BufferOverflowException();
        }
        if (target.isDirect()) {
            long targetPointer = HybridMemorySegment.getAddress(target) + (long)targetOffset;
            long sourcePointer = this.address + (long)offset;
            if (sourcePointer <= this.addressLimit - (long)numBytes) {
                UNSAFE.copyMemory(this.heapMemory, sourcePointer, null, targetPointer, numBytes);
                target.position(targetOffset + numBytes);
                return;
            }
            if (this.address <= this.addressLimit) throw new IndexOutOfBoundsException();
            throw new IllegalStateException("segment has been freed");
        }
        if (target.hasArray()) {
            this.get(offset, target.array(), targetOffset + target.arrayOffset(), numBytes);
            target.position(targetOffset + numBytes);
            return;
        }
        while (target.hasRemaining()) {
            target.put(this.get(offset++));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void put(int offset, ByteBuffer source, int numBytes) {
        if ((offset | numBytes | offset + numBytes) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int sourceOffset = source.position();
        int remaining = source.remaining();
        if (remaining < numBytes) {
            throw new BufferUnderflowException();
        }
        if (source.isDirect()) {
            long sourcePointer = HybridMemorySegment.getAddress(source) + (long)sourceOffset;
            long targetPointer = this.address + (long)offset;
            if (targetPointer <= this.addressLimit - (long)numBytes) {
                UNSAFE.copyMemory(null, sourcePointer, this.heapMemory, targetPointer, numBytes);
                source.position(sourceOffset + numBytes);
                return;
            }
            if (this.address <= this.addressLimit) throw new IndexOutOfBoundsException();
            throw new IllegalStateException("segment has been freed");
        }
        if (source.hasArray()) {
            this.put(offset, source.array(), sourceOffset + source.arrayOffset(), numBytes);
            source.position(sourceOffset + numBytes);
            return;
        }
        while (source.hasRemaining()) {
            this.put(offset++, source.get());
        }
    }

    private static long getAddress(ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is null");
        }
        try {
            return (Long)ADDRESS_FIELD.get(buffer);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not access direct byte buffer address.", t);
        }
    }

    private static long checkBufferAndGetAddress(ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is null");
        }
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("Can't initialize from non-direct ByteBuffer.");
        }
        return HybridMemorySegment.getAddress(buffer);
    }

    static {
        try {
            ADDRESS_FIELD = Buffer.class.getDeclaredField("address");
            ADDRESS_FIELD.setAccessible(true);
        }
        catch (Throwable t) {
            throw new RuntimeException("Cannot initialize HybridMemorySegment: off-heap memory is incompatible with this JVM.", t);
        }
        FACTORY = new HybridMemorySegmentFactory();
    }

    public static final class HybridMemorySegmentFactory
    implements MemorySegmentFactory.Factory {
        @Override
        public HybridMemorySegment wrap(byte[] memory) {
            return new HybridMemorySegment(memory);
        }

        @Override
        public HybridMemorySegment allocateUnpooledSegment(int size, Object owner) {
            return new HybridMemorySegment(new byte[size], owner);
        }

        @Override
        public HybridMemorySegment wrapPooledHeapMemory(byte[] memory, Object owner) {
            return new HybridMemorySegment(memory, owner);
        }

        @Override
        public HybridMemorySegment wrapPooledOffHeapMemory(ByteBuffer memory, Object owner) {
            return new HybridMemorySegment(memory, owner);
        }

        HybridMemorySegmentFactory() {
        }
    }
}

