/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class ByteParser
extends FieldParser<Byte> {
    private byte result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, Byte reusable) {
        int val = 0;
        boolean neg = false;
        int delimLimit = limit - delimiter.length + 1;
        if (bytes[startPos] == 45) {
            neg = true;
            if (++startPos == limit || startPos < delimLimit && ByteParser.delimiterNext(bytes, startPos, delimiter)) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ORPHAN_SIGN);
                return -1;
            }
        }
        for (int i = startPos; i < limit; ++i) {
            if (i < delimLimit && ByteParser.delimiterNext(bytes, i, delimiter)) {
                if (i == startPos) {
                    this.setErrorState(FieldParser.ParseErrorState.EMPTY_STRING);
                    return -1;
                }
                this.result = (byte)(neg ? -val : val);
                return i + delimiter.length;
            }
            if (bytes[i] < 48 || bytes[i] > 57) {
                this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
                return -1;
            }
            val *= 10;
            if ((val += bytes[i] - 48) <= 127 || neg && val <= 128) continue;
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_OVERFLOW_UNDERFLOW);
            return -1;
        }
        this.result = (byte)(neg ? -val : val);
        return limit;
    }

    @Override
    public Byte createValue() {
        return (byte)-128;
    }

    @Override
    public Byte getLastResult() {
        return this.result;
    }

    public static final byte parseField(byte[] bytes, int startPos, int length) {
        return ByteParser.parseField(bytes, startPos, length, '\uffff');
    }

    public static final byte parseField(byte[] bytes, int startPos, int length, char delimiter) {
        long val = 0L;
        boolean neg = false;
        if (bytes[startPos] == delimiter) {
            throw new NumberFormatException("Empty field.");
        }
        if (bytes[startPos] == 45) {
            neg = true;
            if (--length == 0 || bytes[++startPos] == delimiter) {
                throw new NumberFormatException("Orphaned minus sign.");
            }
        }
        while (length > 0) {
            if (bytes[startPos] == delimiter) {
                return (byte)(neg ? -val : val);
            }
            if (bytes[startPos] < 48 || bytes[startPos] > 57) {
                throw new NumberFormatException("Invalid character.");
            }
            val *= 10L;
            if (!((val += (long)(bytes[startPos] - 48)) <= 127L || neg && val <= 128L)) {
                throw new NumberFormatException("Value overflow/underflow");
            }
            ++startPos;
            --length;
        }
        return (byte)(neg ? -val : val);
    }
}

