/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;

@PublicEvolving
public class ResourceManagerOptions {
    private static final String START_WORKER_RETRY_INTERVAL_KEY = "resourcemanager.start-worker.retry-interval";
    public static final ConfigOption<String> JOB_TIMEOUT = ConfigOptions.key("resourcemanager.job.timeout").stringType().defaultValue("5 minutes").withDescription("Timeout for jobs which don't have a job manager as leader assigned.");
    @Deprecated
    public static final ConfigOption<Integer> LOCAL_NUMBER_RESOURCE_MANAGER = ConfigOptions.key("local.number-resourcemanager").intType().defaultValue(1).withDescription("The number of resource managers start.");
    public static final ConfigOption<Integer> IPC_PORT = ConfigOptions.key("resourcemanager.rpc.port").intType().defaultValue(0).withDescription("Defines the network port to connect to for communication with the resource manager. By default, the port of the JobManager, because the same ActorSystem is used. Its not possible to use this configuration key to define port ranges.");
    @Documentation.Section(value={"expert_scheduling"})
    @Documentation.OverrideDefault(value="infinite")
    public static final ConfigOption<Integer> MAX_SLOT_NUM = ConfigOptions.key("slotmanager.number-of-slots.max").intType().defaultValue(Integer.MAX_VALUE).withDescription("Defines the maximum number of slots that the Flink cluster allocates. This configuration option is meant for limiting the resource consumption for batch workloads. It is not recommended to configure this option for streaming workloads, which may fail if there are not enough slots. Note that this configuration option does not take effect for standalone clusters, where how many slots are allocated is not controlled by Flink.");
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<Double> MAX_TOTAL_CPU = ConfigOptions.key("slotmanager.max-total-resource.cpu").doubleType().noDefaultValue().withDescription("Maximum cpu cores the Flink cluster allocates for slots. Resources for JobManager and TaskManager framework are excluded. If not configured, it will be derived from '" + MAX_SLOT_NUM.key() + "'.");
    @Documentation.Section(value={"expert_scheduling"})
    public static final ConfigOption<MemorySize> MAX_TOTAL_MEM = ConfigOptions.key("slotmanager.max-total-resource.memory").memoryType().noDefaultValue().withDescription("Maximum memory size the Flink cluster allocates for slots. Resources for JobManager and TaskManager framework are excluded. If not configured, it will be derived from '" + MAX_SLOT_NUM.key() + "'.");
    public static final ConfigOption<Integer> REDUNDANT_TASK_MANAGER_NUM = ConfigOptions.key("slotmanager.redundant-taskmanager-num").intType().defaultValue(0).withDescription("The number of redundant task managers. Redundant task managers are extra task managers started by Flink, in order to speed up job recovery in case of failures due to task manager lost. Note that this feature is available only to the active deployments (native K8s, Yarn).");
    public static final ConfigOption<Double> START_WORKER_MAX_FAILURE_RATE = ConfigOptions.key("resourcemanager.start-worker.max-failure-rate").doubleType().defaultValue(10.0).withDescription("The maximum number of start worker failures (Native Kubernetes / Yarn) per minute before pausing requesting new workers. Once the threshold is reached, subsequent worker requests will be postponed to after a configured retry interval ('resourcemanager.start-worker.retry-interval').");
    public static final ConfigOption<Duration> START_WORKER_RETRY_INTERVAL = ConfigOptions.key("resourcemanager.start-worker.retry-interval").durationType().defaultValue(Duration.ofSeconds(3L)).withDescription("The time to wait before requesting new workers (Native Kubernetes / Yarn) once the max failure rate of starting workers ('" + START_WORKER_MAX_FAILURE_RATE.key() + "') is reached.");
    @Documentation.ExcludeFromDocumentation(value="This is an expert option, that we do not want to expose in the documentation")
    public static final ConfigOption<Duration> REQUIREMENTS_CHECK_DELAY = ConfigOptions.key("slotmanager.requirement-check.delay").durationType().defaultValue(Duration.ofMillis(50L)).withDescription("The delay of the resource requirements check.");
    @Documentation.ExcludeFromDocumentation(value="This is an expert option, that we do not want to expose in the documentation")
    public static final ConfigOption<Duration> DECLARE_NEEDED_RESOURCE_DELAY = ConfigOptions.key("slotmanager.declare-needed-resource.delay").durationType().defaultValue(Duration.ofMillis(50L)).withDescription("The delay of the declare needed resources.");
    @Deprecated
    public static final ConfigOption<Long> SLOT_REQUEST_TIMEOUT = ConfigOptions.key("slotmanager.request-timeout").longType().defaultValue(-1L).withDescription("The timeout for a slot request to be discarded.");
    public static final ConfigOption<Long> STANDALONE_CLUSTER_STARTUP_PERIOD_TIME = ConfigOptions.key("resourcemanager.standalone.start-up-time").longType().defaultValue(-1L).withDescription(Description.builder().text("Time in milliseconds of the start-up period of a standalone cluster. During this time, resource manager of the standalone cluster expects new task executors to be registered, and will not fail slot requests that can not be satisfied by any current registered slots. After this time, it will fail pending and new coming requests immediately that can not be satisfied by registered slots. If not set, %s will be used by default.", TextElement.code(JobManagerOptions.SLOT_REQUEST_TIMEOUT.key())).build());
    @Deprecated
    public static final ConfigOption<Long> SLOT_MANAGER_TASK_MANAGER_TIMEOUT = ConfigOptions.key("slotmanager.taskmanager-timeout").longType().defaultValue(30000L).withDescription("The timeout for an idle task manager to be released.");
    public static final ConfigOption<Long> TASK_MANAGER_TIMEOUT = ConfigOptions.key("resourcemanager.taskmanager-timeout").longType().defaultValue(30000L).withDeprecatedKeys(SLOT_MANAGER_TASK_MANAGER_TIMEOUT.key()).withDescription(Description.builder().text("The timeout for an idle task manager to be released.").build());
    @Deprecated
    public static final ConfigOption<Boolean> TASK_MANAGER_RELEASE_WHEN_RESULT_CONSUMED = ConfigOptions.key("resourcemanager.taskmanager-release.wait.result.consumed").booleanType().defaultValue(true).withDescription(Description.builder().text("Release task executor only when each produced result partition is either consumed or failed. 'True' is default. 'False' means that idle task executor release is not blocked by receiver confirming consumption of result partition and can happen right away after 'resourcemanager.taskmanager-timeout' has elapsed. Setting this option to 'false' can speed up task executor release but can lead to unexpected failures if end of consumption is slower than 'resourcemanager.taskmanager-timeout'.").build());
    public static final String CONTAINERIZED_MASTER_ENV_PREFIX = "containerized.master.env.";
    public static final String CONTAINERIZED_TASK_MANAGER_ENV_PREFIX = "containerized.taskmanager.env.";
    public static final ConfigOption<Duration> TASK_MANAGER_REGISTRATION_TIMEOUT = ConfigOptions.key("resourcemanager.taskmanager-registration.timeout").durationType().defaultValue(TaskManagerOptions.REGISTRATION_TIMEOUT.defaultValue()).withFallbackKeys(TaskManagerOptions.REGISTRATION_TIMEOUT.key()).withDescription("Timeout for TaskManagers to register at the active resource managers. If exceeded, active resource manager will release and try to re-request the resource for the worker. If not configured, fallback to '" + TaskManagerOptions.REGISTRATION_TIMEOUT.key() + "'.");
    public static final ConfigOption<Duration> RESOURCE_MANAGER_PREVIOUS_WORKER_RECOVERY_TIMEOUT = ConfigOptions.key("resourcemanager.previous-worker.recovery.timeout").durationType().defaultValue(Duration.ofSeconds(0L)).withDescription("Timeout for resource manager to recover all the previous attempts workers. If exceeded, resource manager will handle new resource requests by requesting new workers. If you would like to reuse the previous workers as much as possible, you should configure a longer timeout time to wait for previous workers to register.");

    private ResourceManagerOptions() {
    }
}

